﻿using CodeRepo.Libs;
using CodeRepo.Models;
using System.Windows;
using System.Windows.Input;

namespace CodeRepo.ViewModels
{
    public class EditFragmentViewModel : NotifyObject
    {
        public EditFragmentViewModel(Fragment fragment)
        {
            Fragment = fragment;
        }

        private Fragment _fragment;
        public Fragment Fragment
        {
            get => _fragment;
            set
            {
                if (_fragment == value) return;
                _fragment = value;
                OnPropertyChanged(() => Fragment);
            }
        }

        #region Ok

        RelayCommand _okCommand;
        public ICommand OkCommand => _okCommand ?? (_okCommand = new RelayCommand(OkCommandExecute, OkCommandCanExecute));

        void OkCommandExecute(object window)
        {
            if ((window as Window) != null)
            {
                Fragment.Update();
                (window as Window).Close();
            }
        }

        bool OkCommandCanExecute(object param)
        {
            return true;
        }

        #endregion

    }
}
