﻿using System.Linq;

namespace CodeRepo.Models
{
    public class Fragment
    {
        public int Id { get; set; }

        public string Name { get; set; }

        public string Code { get; set; }


        public void Update()
        {
            using (var db = new FragmentDb())
            {
                var foundFragment = db.Fragments.FirstOrDefault(frag => frag.Id == Id);
                if (foundFragment != null)
                {
                    foundFragment.Name = Name;
                    foundFragment.Code = Code;
                    db.SaveChanges();
                }
                else
                    AddToDb();
            }
        }

        public void AddToDb()
        {
            using (var db = new FragmentDb())
            {
                db.Fragments.Add(this);
                db.SaveChanges();
            }
        }

        public void RemoveFromDb()
        {
            using (var db = new FragmentDb())
            {
                var foundFragment = db.Fragments.FirstOrDefault(frag => frag.Id == Id);
                if (foundFragment != null)
                {
                    db.Fragments.Remove(foundFragment);
                    db.SaveChanges();
                }
            }
        }

    }
}
