﻿using System;

namespace ProgramowanieObiektowe
{
    class Ułamek : IComparable<Ułamek>, ICloneable
    {
        //private int licznik = 0;
        private int mianownik = 1;

        /*
        public int Licznik
        {
            get
            {
                return licznik;
            }
            set
            {
                licznik = value;
            }
        }
        */

        public int Licznik { get; set; } = 0;

        public int Mianownik
        {
            get
            {
                return mianownik;
            }
            set
            {
                if (value == 0) throw new ArgumentException("Mianownik nie może być równy zeru");
                else mianownik = value;
            }
        }

        public Ułamek(int licznik = 0, int mianownik = 1)
        {
            this.Licznik = licznik;
            this.Mianownik = mianownik;            
        }

        public Ułamek(Ułamek u) //konstruktor kopiujący/copy
        {
            this.Licznik = u.Licznik;
            this.Mianownik = u.Mianownik;
        }

        public static Ułamek Połowa = new Ułamek(1, 2);

        static Ułamek()
        {
            Console.WriteLine("Konstruktor statyczny");
            //w naszym przykładzie nie ma dla tego użytku
        }
        

        ~Ułamek()
        {
            Console.WriteLine("Destruktor");
            //tu należy zwolnić zasoby niezarządzane
        }

        public override string ToString()
        {
            return Licznik.ToString() + "/" + Mianownik.ToString();
        }

        public double ToDouble()
        {
            return Licznik / (double)Mianownik;
        }

        #region Operatory arytmetyczne
        public static Ułamek operator +(Ułamek u1, Ułamek u2)
        {
            return new Ułamek(u1.Licznik * u2.Mianownik + u2.Licznik * u1.Mianownik, u1.Mianownik * u2.Mianownik);
        }

        public static Ułamek operator -(Ułamek u1, Ułamek u2)
        {
            return new Ułamek(u1.Licznik * u2.Mianownik - u2.Licznik * u1.Mianownik, u1.Mianownik * u2.Mianownik);
        }

        public static Ułamek operator *(Ułamek u1, Ułamek u2)
        {
            return new Ułamek(u1.Licznik * u2.Licznik, u1.Mianownik * u2.Mianownik);
        }

        public static Ułamek operator /(Ułamek u1, Ułamek u2)
        {
            return new Ułamek(u1.Licznik * u2.Mianownik, u1.Mianownik * u2.Licznik);
        }
        #endregion

        #region Operatory porównania
        public static bool operator ==(Ułamek u1, Ułamek u2)
        {
            return u1.ToDouble() == u2.ToDouble();
        }

        public static bool operator !=(Ułamek u1, Ułamek u2)
        {
            return !(u1 == u2);
        }

        public override bool Equals(object obj)
        {
            if (!(obj is Ułamek)) return false;
            Ułamek u = (Ułamek)obj;
            return (this == u);
        }

        public override int GetHashCode()
        {
            return Licznik ^ mianownik;
        }        

        public static bool operator >(Ułamek u1, Ułamek u2)
        {
            return u1.ToDouble() > u2.ToDouble();
        }

        public static bool operator <(Ułamek u1, Ułamek u2)
        {
            return u1.ToDouble() < u2.ToDouble();
        }

        public static bool operator >=(Ułamek u1, Ułamek u2)
        {
            return u1.ToDouble() >= u2.ToDouble();
        }

        public static bool operator <=(Ułamek u1, Ułamek u2)
        {
            return u1.ToDouble() <= u2.ToDouble();
        }
        #endregion

        #region Operatory konwersji
        /*[explicit|implicit]*/
        public static explicit operator double(Ułamek u)
        {
            return u.ToDouble();
        }

        public static implicit operator Ułamek(int n)
        {
            return new Ułamek(n);
        }
        #endregion

        #region Interfejsy
        public int CompareTo(Ułamek other)
        {
            return this.ToDouble().CompareTo(other.ToDouble());
        }

        public object Clone()
        {
            //return new Ułamek(this.Licznik, this.Mianownik);
            return new Ułamek(this);
        }
        #endregion
    }

    class Program
    {
        /*
        //to nie ma sensu!
        public void WriteLine(Ułamek u)
        {
            Console.WriteLine(u.Licznik.ToString() + "/" + u.Mianownik.ToString());
        }
        */

        static void Main(string[] args)
        {
            Ułamek u1 = new Ułamek(1, 2);
            Ułamek u2 = new Ułamek(2, 4);
            Ułamek u3 = new Ułamek(1, 3);
            Ułamek u4 = new Ułamek(10, 3);

            Console.WriteLine(u1.ToString());
            Console.WriteLine(u2.ToString());
            Console.WriteLine(u3.ToString());
            Console.WriteLine(u4.ToString());

            Console.WriteLine(u1.ToDouble());
            Console.WriteLine(u2.ToDouble());
            Console.WriteLine(u3.ToDouble());
            Console.WriteLine(u4.ToDouble());

            Ułamek u5 = u1 + u2;
            Console.WriteLine(u5.ToString());

            //To wykorzystać w testach jednostkowych
            Ułamek u6 = u1 + u3;            
            Console.WriteLine(u6.ToString());
            double d6 = u1.ToDouble() + u3.ToDouble();
            Console.WriteLine(u6.ToDouble() + " ?= " + d6);

            Ułamek u7 = new Ułamek() { Licznik = 1, Mianownik = 2 };

            GC.Collect();
            Console.ReadKey();
        }
    }
}
