﻿//#define UMK

using System;
using System.IO;
using System.Text;
using System.Linq;

namespace JezykCS_NETCore
{
    class Program
    {
        //Typ wyliczeniowy
        enum DniTygodnia : byte { Niedziela = 1, Poniedziałek, Wtorek, Środa, Czwartek, Piątek, Sobota };

        static void Main1()
        {
            DniTygodnia dzień = (DniTygodnia)Enum.Parse(typeof(DniTygodnia), "Poniedziałek");
            Console.WriteLine(dzień.ToString());
            Console.WriteLine(((byte)dzień).ToString());

            switch(dzień)
            {
                case DniTygodnia.Niedziela:
                    Console.WriteLine("Odpoczywamy");
                    break;
                default:
                    throw new Exception("Nierozpoznana wartość zmiennej");
            }
        }

        //Delegacje
        delegate int TypMetodyKtóraPodnosiDoKwadratu(byte arg);

        static event TypMetodyKtóraPodnosiDoKwadratu Zdarzenie;
        static TypMetodyKtóraPodnosiDoKwadratu j;

        private static int Kwadrat(byte arg)
        {
            Console.WriteLine("Obliczam kwadrat");
            return arg * arg;
        }

        private static int Sześcian(byte arg)
        {
            Console.WriteLine("Obliczam sześcian");
            return arg * arg * arg;
        }

        static void Main2()
        {
            int i = Kwadrat(2);
            Console.WriteLine(i.ToString());

            j = Kwadrat;
            i = j(2);
            Console.WriteLine("1:" + i.ToString());
            j += Sześcian;
            i = j(2);
            Console.WriteLine("2:" + i.ToString());

            Zdarzenie = Kwadrat;
            i = Zdarzenie(3);
            Console.WriteLine("3:" + i.ToString());
            Zdarzenie += Sześcian;
            i = Zdarzenie(3);
            Console.WriteLine("4:" + i.ToString());

            Klasa instancja = new Klasa();
            instancja.j = Kwadrat;
            i = instancja.j(2);
            Console.WriteLine("5: " + i.ToString());
            instancja.j += Sześcian;
            i = j(2);
            Console.WriteLine("6:" + i.ToString());

            instancja.Zdarzenie += Kwadrat;
            //i = instancja.Zdarzenie(3);
            Console.WriteLine("7:" + i.ToString());
            instancja.Zdarzenie += Sześcian;
            //i = instancja.Zdarzenie(3);
            Console.WriteLine("8:" + i.ToString());
        }

        class Klasa
        {
            public delegate int TypMetodyKtóraPodnosiDoKwadratu(byte arg);

            public event TypMetodyKtóraPodnosiDoKwadratu Zdarzenie;
            public TypMetodyKtóraPodnosiDoKwadratu j;

            protected void onZdarzenie()
            {
                if (Zdarzenie != null) Zdarzenie(10);
            }
        }

        //Wyrażenia Lambda
        static void Main3()
        {
            TypMetodyKtóraPodnosiDoKwadratu kwadrat = (byte arg) => { return arg * arg; };
            TypMetodyKtóraPodnosiDoKwadratu kwadrat2 = arg => arg * arg;
            Func<byte, int> kwadrat3 = Kwadrat;
            Func<byte, int> kwadrat4 = arg => arg * arg;            
            int i = kwadrat(2);
            Console.WriteLine(i.ToString());

            int[] tablica = { 1, 2, 3, 5, 67, 89, 45, 3 };
            var podtablica1 = tablica.Where((int _i) => { return _i > 10; }).OrderByDescending(_i => _i).Select(_i => _i.ToString());
            var podtablica2 = tablica.Where(_i => _i > 10);

            var podtablica3 = from element in tablica
                              where element > 10
                              orderby element descending
                              select element.ToString();

            string s = "";
            foreach (var element in podtablica3) s += element.ToString() + "\n";
            Console.WriteLine(s);
        }

        //Nullable
        static void Main4()
        {
            //Nullable<int> i = null;
            int? i = null;
            Random r = new Random();
            do
            {
                int _i = r.Next();
                if (_i > 25) i = _i;
            }
            while (i > 50);
            if (i.HasValue) Console.WriteLine(i.Value.ToString());
            
        }

        //zwracanie wartości przez argumenty
        private static void inkrementujParęLiczb(ref int i, ref int j)
        {
            i++;
            j++;
        }

        [Obsolete("Metoda przestarzała. Nie używać")]
        private static void zainicjujParęZmiennych(out int a, out int b)
        {
            a = 5;
            b = 6;
        }
        
        private static Tuple<int, int> zainicjujParęZmiennych()
        {
            return new Tuple<int, int>(5, 6);            
        }

        static void Main5()
        {
            int i = 1;
            int j = 3;
            inkrementujParęLiczb(ref i, ref j);
            Console.WriteLine("" + i + ", " + j);

            int a, b;
            zainicjujParęZmiennych(out a, out b);
            Console.WriteLine("" + a + ", " + b);
        }

        #region Wyjątki
        //Wyjątki
        private static void funkcjaZgłaszającaWyjątek()
        {
            try
            {
                int x = 0;
                if (x == 0) throw new ArgumentException("Nie podoba mi się argumement x");
                int y = 1 / x;
                Console.WriteLine("To polecenie nie zostanie nigdy wykonane");
            }
            catch (DivideByZeroException exc)
            {
                Console.Error.WriteLine("Pamiętaj cholero, nie dziel przez zero!");
                return;
            }
            catch (ArgumentException exc)
            {
                Console.WriteLine("Obsługa wyjątku dla złego argumentu");
                throw new Exception("Błąd złego argumentu", exc);
            }
            catch (Exception exc)
            {
                Console.Error.WriteLine("Błąd: " + exc.Message);
            }
            finally
            {
                Console.Error.WriteLine("Ostateczność");
            }
            Console.Error.WriteLine("Po wyjątku");
        }


        static void Main6()
        {
            try
            {
                funkcjaZgłaszającaWyjątek();
               
            }
            catch(Exception exc)
            {
                Console.Error.WriteLine("Błąd: " + exc.Message);
                if (exc.InnerException != null)
                    Console.Error.WriteLine(exc.InnerException.Message);
            }
        }
        #endregion

        static void Main7a()
        {
            int[] i1 = new int[5]; // { 1, 2, 3, 4, 5 };
            int[][] i2 = new int[10][];
            for(int i = 0; i < i2.Length; ++i)
            {
                i2[i] = new int[10];
            }
            int[,] i3 = new int[10, 10];
            Console.WriteLine("OK");

            i1[10] = 1;
        }

        /*
        private static void wyświetlTablicę(int[] tablica)
        {
            string s = "";
            foreach (int element in tablica) s += "\n" + element.ToString();
            Console.WriteLine(s);
        }
        */

        private static void wyświetlTablicę<T>(T[] tablica)
        {
            string s = "";
            foreach (T element in tablica) s += "\n" + element.ToString();
            Console.WriteLine(s);
        }

        struct LiczbaCałkowita : IComparable<LiczbaCałkowita>
        {
            public int Wartość { get; set; }

            public LiczbaCałkowita(int wartość = 0)
            {
                this.Wartość = wartość;
            }

            public override string ToString()
            {
                return Wartość.ToString();
            }

            public int CompareTo(LiczbaCałkowita other)
            {
                return Wartość.CompareTo(other.Wartość);
            }
        }

        static void sortujBąbelkowo<T>(T[] tablica)
        {
            throw new NotImplementedException("Zadanie domowe");
        }

        static void Main7b()
        {
            //int[] t = new int[5] { 4, 3, 1, 2, 5 };
            LiczbaCałkowita[] t = new LiczbaCałkowita[5] 
            {
                new LiczbaCałkowita(4),
                new LiczbaCałkowita(3),
                new LiczbaCałkowita(1),
                new LiczbaCałkowita(2),
                new LiczbaCałkowita(5)
            };
            wyświetlTablicę(t);
            Array.Sort(t);
            wyświetlTablicę(t);

            sortujBąbelkowo(t);
        }

        static void Main(string[] args)
        {
            //Main1();
            //Main2();
            //Main3();
            //Main4();
            //Main5();
#if UMK
            Main6();
#endif
            Main7b();
        }
    }
}
