﻿using System;
using System.IO;
using System.Text;
using System.Linq;

namespace JezykCS_NETCore
{
    class Program
    {
        //Typ wyliczeniowy
        enum DniTygodnia : byte { Niedziela = 1, Poniedziałek, Wtorek, Środa, Czwartek, Piątek, Sobota };

        static void Main1()
        {
            DniTygodnia dzień = (DniTygodnia)Enum.Parse(typeof(DniTygodnia), "Poniedziałek");
            Console.WriteLine(dzień.ToString());
            Console.WriteLine(((byte)dzień).ToString());

            switch(dzień)
            {
                case DniTygodnia.Niedziela:
                    Console.WriteLine("Odpoczywamy");
                    break;
                default:
                    throw new Exception("Nierozpoznana wartość zmiennej");
            }
        }

        //Delegacje
        delegate int TypMetodyKtóraPodnosiDoKwadratu(byte arg);

        static event TypMetodyKtóraPodnosiDoKwadratu Zdarzenie;
        static TypMetodyKtóraPodnosiDoKwadratu j;

        private static int Kwadrat(byte arg)
        {
            Console.WriteLine("Obliczam kwadrat");
            return arg * arg;
        }

        private static int Sześcian(byte arg)
        {
            Console.WriteLine("Obliczam sześcian");
            return arg * arg * arg;
        }

        static void Main2()
        {
            int i = Kwadrat(2);
            Console.WriteLine(i.ToString());

            j = Kwadrat;
            i = j(2);
            Console.WriteLine("1:" + i.ToString());
            j += Sześcian;
            i = j(2);
            Console.WriteLine("2:" + i.ToString());

            Zdarzenie = Kwadrat;
            i = Zdarzenie(3);
            Console.WriteLine("3:" + i.ToString());
            Zdarzenie += Sześcian;
            i = Zdarzenie(3);
            Console.WriteLine("4:" + i.ToString());

            Klasa instancja = new Klasa();
            instancja.j = Kwadrat;
            i = instancja.j(2);
            Console.WriteLine("5: " + i.ToString());
            instancja.j += Sześcian;
            i = j(2);
            Console.WriteLine("6:" + i.ToString());

            instancja.Zdarzenie += Kwadrat;
            //i = instancja.Zdarzenie(3);
            Console.WriteLine("7:" + i.ToString());
            instancja.Zdarzenie += Sześcian;
            //i = instancja.Zdarzenie(3);
            Console.WriteLine("8:" + i.ToString());
        }

        class Klasa
        {
            public delegate int TypMetodyKtóraPodnosiDoKwadratu(byte arg);

            public event TypMetodyKtóraPodnosiDoKwadratu Zdarzenie;
            public TypMetodyKtóraPodnosiDoKwadratu j;

            protected void onZdarzenie()
            {
                if (Zdarzenie != null) Zdarzenie(10);
            }
        }

        //Wyrażenia Lambda
        static void Main3()
        {
            TypMetodyKtóraPodnosiDoKwadratu kwadrat = (byte arg) => { return arg * arg; };
            TypMetodyKtóraPodnosiDoKwadratu kwadrat2 = arg => arg * arg;
            Func<byte, int> kwadrat3 = Kwadrat;
            Func<byte, int> kwadrat4 = arg => arg * arg;            
            int i = kwadrat(2);
            Console.WriteLine(i.ToString());

            int[] tablica = { 1, 2, 3, 5, 67, 89, 45, 3 };
            var podtablica1 = tablica.Where((int _i) => { return _i > 10; }).OrderByDescending(_i => _i).Select(_i => _i.ToString());
            var podtablica2 = tablica.Where(_i => _i > 10);

            var podtablica3 = from element in tablica
                              where element > 10
                              orderby element descending
                              select element.ToString();

            string s = "";
            foreach (var element in podtablica3) s += element.ToString() + "\n";
            Console.WriteLine(s);
        }

        static void Main(string[] args)
        {
            //Main1();
            //Main2();
            Main3();
        }
    }
}
