﻿using Kolory.ModelWidoku;
using System;
using Windows.UI;
using Windows.UI.Xaml.Data;
using Windows.UI.Xaml.Media;

namespace Kolory
{
    public class ByteToDouble : IValueConverter
    {
        public object Convert(object value, Type targetType, object parameter, string language)
        {
            return (double)(byte)value;
        }

        public object ConvertBack(object value, Type targetType, object parameter, string language)
        {
            return (byte)(double)value;
        }
    }

    public class EdytorKoloruToBrush : IValueConverter
    {
        public object Convert(object value, Type targetType, object parameter, string language)
        {
            EdycjaKoloru modelWidoku = (EdycjaKoloru)value;
            Color color = Color.FromArgb(255, modelWidoku.R, modelWidoku.G, modelWidoku.B);
            return new SolidColorBrush(color);
        }

        public object ConvertBack(object value, Type targetType, object parameter, string language)
        {
            throw new NotImplementedException();
        }
    }
}
