﻿using System;
using System.ComponentModel;
using System.Windows.Input;

namespace Kolory.ModelWidoku
{
    public class EdycjaKoloru : INotifyPropertyChanged
    {
        private Model.Kolor model = Model.Ustawienia.Load();

        private string getColorHexCode()
        {
            return "#" + R.ToString("X2") + G.ToString("X2") + B.ToString("X2");
        }

        #region Własności
        public byte R
        {
            get
            {
                return model.R;
            }
            set
            {
                model.R = value;
                onPropertyChanged(nameof(R), nameof(ColorHexCode));
            }
        }

        public byte G
        {
            get
            {
                return model.G;
            }
            set
            {
                model.G = value;
                onPropertyChanged(nameof(G), nameof(ColorHexCode));
            }
        }

        public byte B
        {
            get
            {
                return model.B;
            }
            set
            {
                model.B = value;
                onPropertyChanged(nameof(B), nameof(ColorHexCode));
            }
        }

        public string ColorHexCode
        {
            get
            {
                return getColorHexCode();
            }
        }
        #endregion

        #region Polecenia
        private ICommand resetuj;

        public ICommand Resetuj
        {
            get
            {
                if (resetuj == null)
                {
                    //resetuj = new PolecenieResetowania(model);
                    Action<object> execute =
                        (object parametr) =>
                        {
                            model.R = 0;
                            model.G = 0;
                            model.B = 0;
                            onPropertyChanged(nameof(R), nameof(G), nameof(B), nameof(ColorHexCode));
                        };
                    Func<object, bool> canExecute =
                        (object parametr) => 
                        {
                            return model.R != 0 || model.G != 0 || model.B != 0;
                        };
                    resetuj = new RelayCommand(execute, canExecute);
                }
                return resetuj;
            }
        }        

        private ICommand kopiuj;

        public ICommand Kopiuj
        {
            get
            {
#if WINDOWS_UWP
                if (kopiuj == null) kopiuj = new RelayCommand(
                    (object parameter) => 
                    {
                        Windows.ApplicationModel.DataTransfer.DataPackage dataPackage = new Windows.ApplicationModel.DataTransfer.DataPackage { RequestedOperation = Windows.ApplicationModel.DataTransfer.DataPackageOperation.Copy };
                        dataPackage.SetText(getColorHexCode());
                        Windows.ApplicationModel.DataTransfer.Clipboard.SetContent(dataPackage);
                    });
#else
                if(kopiuj == null) kopiuj = new RelayCommand((object parameter) => { System.Windows.Clipboard.SetText(getColorHexCode()); });
#endif
                return kopiuj;
            }
        }
#endregion

#region Obsługa zdarzenia PropertyChanged
        public event PropertyChangedEventHandler PropertyChanged;

        private void onPropertyChanged(params string[] nazwyWłasności)
        {
            if(PropertyChanged != null)
            {
                foreach(string nazwaWłasności in nazwyWłasności)
                {
                    PropertyChanged(this, new PropertyChangedEventArgs(nazwaWłasności));
                }
            }
        }
#endregion

        /*
        public void Zapisz()
        {
            Model.Ustawienia.Save(model);
        }
        */

        private ICommand zapisz;

        public ICommand Zapisz
        {
            get
            {
                if (zapisz == null) zapisz = new RelayCommand(p => Model.Ustawienia.Save(model));
                return zapisz;
            }            
        }
    }
}
