﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Input;

namespace Kolory.ModelWidoku
{
    public class PolecenieResetowania : ICommand
    {
        private Model.Kolor model;

        public PolecenieResetowania(Model.Kolor model)
        {
            this.model = model;
        }

        public event EventHandler CanExecuteChanged
        {
            add { CommandManager.RequerySuggested += value; }
            remove { CommandManager.RequerySuggested -= value; }
        }


        public bool CanExecute(object parameter)
        {
            return model.R != 0 || model.G != 0 || model.B != 0;
        }

        public void Execute(object parameter)
        {
            model.R = 0;
            model.G = 0;
            model.B = 0;
        }
    }

    public class RelayCommand : ICommand
    {
        Func<object, bool> canExecute;
        Action<object> execute;

        public RelayCommand(Action<object> execute, Func<object, bool> canExecute = null)
        {
            if (execute == null) throw new ArgumentException("Argument 'execute' nie może być pusty");
            this.execute = execute;
            this.canExecute = canExecute;
        }

        public event EventHandler CanExecuteChanged
        {
            add { CommandManager.RequerySuggested += value; }
            remove { CommandManager.RequerySuggested -= value; }
        }


        public bool CanExecute(object parameter)
        {
            if (canExecute == null) return true;
            else return canExecute(parameter);
        }

        public void Execute(object parameter)
        {
            execute(parameter);
        }
    }
}
