﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Text;
using System.Windows.Input;

namespace Kolory.ModelWidoku
{
    public class EdycjaKoloru : INotifyPropertyChanged
    {
        private Model.Kolor model = Model.Ustawienia.Load();

        private string getColorHexCode()
        {
            return "#" + R.ToString("X2") + G.ToString("X2") + B.ToString("X2");
        }

        #region Własności
        public byte R
        {
            get
            {
                return model.R;
            }
            set
            {
                model.R = value;
                onPropertyChanged(nameof(R), nameof(Brush), nameof(ColorHexCode));
            }
        }

        public byte G
        {
            get
            {
                return model.G;
            }
            set
            {
                model.G = value;
                onPropertyChanged(nameof(G), nameof(Brush), nameof(ColorHexCode));
            }
        }

        public byte B
        {
            get
            {
                return model.B;
            }
            set
            {
                model.B = value;
                onPropertyChanged(nameof(B), nameof(Brush), nameof(ColorHexCode));
            }
        }

        public System.Windows.Media.SolidColorBrush Brush
        {
            get
            {
                return new System.Windows.Media.SolidColorBrush(System.Windows.Media.Color.FromRgb(R, G, B));
            }
        }

        public string ColorHexCode
        {
            get
            {
                return getColorHexCode();
            }
        }
        #endregion

        #region Polecenia
        private ICommand resetuj;

        public ICommand Resetuj
        {
            get
            {
                if (resetuj == null)
                {
                    //resetuj = new PolecenieResetowania(model);
                    Action<object> execute =
                        (object parametr) =>
                        {
                            model.R = 0;
                            model.G = 0;
                            model.B = 0;
                            onPropertyChanged(nameof(R), nameof(G), nameof(B), nameof(Brush), nameof(ColorHexCode));
                        };
                    Func<object, bool> canExecute =
                        (object parametr) => 
                        {
                            return model.R != 0 || model.G != 0 || model.B != 0;
                        };
                    resetuj = new RelayCommand(execute, canExecute);
                }
                return resetuj;
            }
        }        

        private ICommand kopiuj;

        public ICommand Kopiuj
        {
            get
            {
                if(kopiuj == null) kopiuj = new RelayCommand((object parameter) => { System.Windows.Clipboard.SetText(getColorHexCode()); });
                return kopiuj;
            }
        }
        #endregion

        #region Obsługa zdarzenia PropertyChanged
        public event PropertyChangedEventHandler PropertyChanged;

        private void onPropertyChanged(params string[] nazwyWłasności)
        {
            if(PropertyChanged != null)
            {
                foreach(string nazwaWłasności in nazwyWłasności)
                {
                    PropertyChanged(this, new PropertyChangedEventArgs(nazwaWłasności));
                }
            }
        }
        #endregion

        /*
        public void Zapisz()
        {
            Model.Ustawienia.Save(model);
        }
        */

        private ICommand zapisz;

        public ICommand Zapisz
        {
            get
            {
                if (zapisz == null) zapisz = new RelayCommand(p => Model.Ustawienia.Save(model));
                return zapisz;
            }            
        }

        //bardzo brzydki kod
        public ICommand ZamknijOkno
        {
            get
            {
                return new RelayCommand(p => { App.Current.MainWindow.Close(); });
            }
        }
    }
}
