﻿using System;
using System.Windows;
using System.Windows.Media;

namespace Kolory
{
    /// <summary>
    /// Interaction logic for MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window
    {
        public MainWindow()
        {
            InitializeComponent();
            tbVersion.Text = "Wersja: " + System.Reflection.Assembly.GetExecutingAssembly().GetName().Version.ToString();

            //rectangle.Fill = new SolidColorBrush(Colors.Pink);
            //!!!rectangle.Fill = new SolidColorBrush(Model.Ustawienia.Load());
            Color color = (rectangle.Fill as SolidColorBrush).Color;
            sliderR.Value = color.R;
            sliderG.Value = color.G;
            sliderB.Value = color.B;
            Slider_ValueChanged(this, null);
        }

        private void Slider_ValueChanged(object sender, RoutedPropertyChangedEventArgs<double> e)
        {
            /*
            (rectangle.Fill as SolidColorBrush).Color = Color.FromRgb(
                (byte)(sliderR.Value),
                (byte)(sliderG.Value),
                (byte)(sliderB.Value));
            */
            Color color = (rectangle.Fill as SolidColorBrush).Color;
            tbColorHexCode.Text = "#" + color.R.ToString("X2") + color.G.ToString("X2") + color.B.ToString("X2");
        }

        private void Window_Closed(object sender, EventArgs e)
        {
            Color color = (rectangle.Fill as SolidColorBrush).Color;
            Model.Ustawienia.Save(color);
        }

        private void Button_KopiujDoSchowka_Click(object sender, RoutedEventArgs e)
        {
            Clipboard.SetText(tbColorHexCode.Text);
        }

        private void Button_Zamkij_Click(object sender, RoutedEventArgs e)
        {
            Close();
        }

        private void Button_Restuj_Click(object sender, RoutedEventArgs e)
        {
            sliderR.Value = 0;
            sliderG.Value = 0;
            sliderB.Value = 0;
        }
    }
}
