﻿using System;
using System.Collections.Generic;
using System.Globalization;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Data;
using System.Windows.Media;

namespace Tekst
{
    public class TekstToBrushConverter : IValueConverter
    {
        private static Brush ustalKolor(string tekst)
        {
            int liczba = tekst.Length;
            Brush b;
            if (liczba < 10)
            {
                b = Brushes.Black;
            }
            else if (liczba < 15)
            {
                b = Brushes.Navy;
            }
            else if (liczba < 20)
            {
                b = Brushes.Blue;
            }
            else
            {
                b = Brushes.Cyan;
            }
            return b;
        }

        public object Convert(object value, Type targetType, object parameter, CultureInfo culture)
        {
            string tekst = (string)value;
            return ustalKolor(tekst);
        }

        public object ConvertBack(object value, Type targetType, object parameter, CultureInfo culture)
        {
            throw new NotImplementedException();
        }
    }
}
