﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Media;

namespace Tekst.ModelWidoku
{
    public class TekstVM : INotifyPropertyChanged
    {
        private Model.TekstM model = new Model.TekstM();        

        public string Tekst
        {
            get
            {
                return model.Tekst;
            }
            set
            {
                model.Tekst = value;
                onPropertyChanged();
            }
        }

        private Brush ustalKolor()
        {
            int liczba = Tekst.Length;
            Brush b;
            if (liczba < 10)
            {
                b = Brushes.Black;
            }
            else if (liczba < 15)
            {
                b = Brushes.Navy;
            }
            else if (liczba < 20)
            {
                b = Brushes.Blue;
            }
            else
            {
                b = Brushes.Cyan;
            }
            return b;
        }

        //nieortodoksyjnie
        public Brush Pędzel
        {
            get
            {
                return ustalKolor();
            }
        }

        public event PropertyChangedEventHandler PropertyChanged;

        protected void onPropertyChanged()
        {
            if (PropertyChanged != null)
            {
                PropertyChanged(this, new PropertyChangedEventArgs(nameof(Tekst)));
                PropertyChanged(this, new PropertyChangedEventArgs(nameof(Pędzel)));
            }
        }
    }
}
