﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

namespace Tekst
{
    /// <summary>
    /// Logika interakcji dla klasy MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window
    {
        public MainWindow()
        {
            InitializeComponent();
            textBox.Text = Properties.Settings.Default.Text;
        }

        private void TextBox_TextChanged(object sender, TextChangedEventArgs e)
        {
            textBlock.Text = textBox.Text;
            textBlock.Foreground = ustalKolor();
            Properties.Settings.Default.Text = textBox.Text;
            Properties.Settings.Default.Save();
        }

        private Brush ustalKolor()
        {
            int liczba = textBox.Text.Length;
            Brush b;
            if (liczba < 10)
            {
                b = Brushes.Black;
            }
            else if (liczba < 15)
            {
                b = Brushes.Navy;
            }
            else if (liczba < 20)
            {
                b = Brushes.Blue;
            }
            else
            {
                b = Brushes.Cyan;
            }
            return b;
        }
    }
}
