﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

namespace JacekMatulewski.WpfControls
{
    /// <summary>
    /// Interaction logic for FileChooserDialog.xaml
    /// </summary>
    public partial class FileChooser : UserControl //nie trzeba implementować INotifyPropertyChanged, bo jest UserControl
    {
        public FileChooser()
        {
            InitializeComponent();
        }

        public static DependencyProperty FilePathProperty = DependencyProperty.Register(
            "FilePath", typeof(string), typeof(FileChooser));

        public string FilePath
        {
            get
            {
                return (string)GetValue(FilePathProperty);
            }
            set
            {
                SetValue(FilePathProperty, value);

                //uzgadnianie wewnętrznych kontrolek
                textBox.Text = value;

                //zdarzenie
                FilePathChangedEventArgs args = new FilePathChangedEventArgs() { FilePath = value };
                args.RoutedEvent = FilePathChangedEvent;
                RaiseEvent(args);

                //polecenie
                if (Command != null)
                {
                    if (Command.CanExecute(FilePath))
                    {
                        Command.Execute(FilePath);
                    }
                }
            }
        }

        public class FilePathChangedEventArgs : RoutedEventArgs
        {
            public string FilePath;
        }

        public delegate void FilePathChangedEventHandler(object sender, FilePathChangedEventArgs e);

        public static readonly RoutedEvent FilePathChangedEvent = EventManager.RegisterRoutedEvent(
            "FilePathChanged", RoutingStrategy.Tunnel, typeof(FilePathChangedEventHandler), typeof(FileChooser));

        public event FilePathChangedEventHandler FilePathChanged
        {
            add
            {
                AddHandler(FilePathChangedEvent, value);
            }
            remove
            {
                RemoveHandler(FilePathChangedEvent, value);
            }
        }

        private void Button_Click(object sender, RoutedEventArgs e)
        {
            Microsoft.Win32.OpenFileDialog ofd = new Microsoft.Win32.OpenFileDialog();
            ofd.Filter = this.Filter;
            ofd.FilterIndex = this.FilterIndex;
            ofd.FileName = FilePath;
            bool? result = ofd.ShowDialog();
            if (result.HasValue && result.Value)
            {
                FilePath = ofd.FileName;
            }
        }

        public static DependencyProperty FilterProperty
            = DependencyProperty.Register(
            "Filter", typeof(string), typeof(FileChooser));

        public string Filter 
        { 
            get
            {
                return (string)GetValue(FilterProperty);
            }
            set
            {
                SetValue(FilterProperty, value);
            }
        }

        public static DependencyProperty FilterIndexProperty
            = DependencyProperty.Register(
            "FilterIndex", typeof(int), typeof(FileChooser));

        public int FilterIndex
        {
            get
            {
                return (int)GetValue(FilterIndexProperty);
            }
            set
            {
                SetValue(FilterIndexProperty, value);
            }
        }

        //ZADANIE: zdefiniować Label jako własność zależności

        public static readonly DependencyProperty CommandProperty
            = DependencyProperty.Register(
                "Command",
                typeof(ICommand),
                typeof(FileChooser));

        public ICommand Command
        {
            get
            {
                return (ICommand)GetValue(CommandProperty);
            }
            set
            {
                SetValue(CommandProperty, value);
            }
        }
    }
}
