﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

namespace FileChooserDemo
{
    /// <summary>
    /// Interaction logic for MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window
    {
        public MainWindow()
        {
            InitializeComponent();
        }

        private void fileChooser_FilePathChanged(object sender, JacekMatulewski.WpfControls.FileChooser.FilePathChangedEventArgs e)
        {
            MessageBox.Show("Routed event: " + e.FilePath);
        }

        private ICommand zmianaŚcieżki;

        public ICommand ZmianaŚcieżki
        {
            get
            {
                if (zmianaŚcieżki == null)
                    zmianaŚcieżki = new MvvmCommand((object parametr) => { MessageBox.Show("Command: " + (string)parametr); });
                return zmianaŚcieżki;
            }
        }

        public string ApplicationExePath
        {
            get
            {
                return System.Reflection.Assembly.GetExecutingAssembly().Location;
            }
        }

        private int liczba = 2;

        public int Liczba
        {
            get
            {
                return liczba;
            }
            set
            {
                liczba = value;
            }
        }

        public string Łańcuch
        {
            get
            {
                return "Wybrany plik:";
            }
        }
    }
}
