﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace JacekMatulewski.WpfControls
{
    public class FileChooserViewModel : INotifyPropertyChanged
    {
        private FileChooserModel model = new FileChooserModel();

        public string FilePath
        {
            get
            {
                return model.FilePath;
            }
            set
            {
                if (System.IO.File.Exists(value)) model.FilePath = value;
                else throw new System.IO.FileNotFoundException("Nie ma pliku", value);
                OnPropertyChanged();
            }
        }

        public event PropertyChangedEventHandler PropertyChanged;

        private void OnPropertyChanged()
        {
            if(PropertyChanged!=null) PropertyChanged(this, new PropertyChangedEventArgs("FilePath"));
        }
    }
}
