﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

namespace JacekMatulewski.WpfControls
{
    /// <summary>
    /// Interaction logic for FileChooserDialog.xaml
    /// </summary>
    public partial class FileChooserDialog : UserControl, INotifyPropertyChanged
    {
        public FileChooserDialog()
        {
            InitializeComponent();
            textBox.TextChanged += textBox_TextChanged;
        }

        void textBox_TextChanged(object sender, TextChangedEventArgs e)
        {
            if (FilePathChanged != null) FilePathChanged(this, new FilePathChangedEventArgs() { FilePath = this.FilePath });
        }

        public string Filter { get; set; }
        public int FilterIndex { get; set; }

        public string FilePath 
        { 
            get
            {
                return textBox.Text;
                OnPropertyChanged("FilePath");
            }
        }

        public class FilePathChangedEventArgs : RoutedEventArgs
        {
            public string FilePath;
        }

        public delegate void FilePathChangedEventHandler(object sender, FilePathChangedEventArgs e);

        public event FilePathChangedEventHandler FilePathChanged;

        private void Button_Click(object sender, RoutedEventArgs e)
        {
            Microsoft.Win32.OpenFileDialog ofd = new Microsoft.Win32.OpenFileDialog();
            ofd.Filter = this.Filter;
            ofd.FilterIndex = this.FilterIndex;
            ofd.FileName = textBox.Text;
            bool? result = ofd.ShowDialog();
            if(result.HasValue && result.Value)
            {
                textBox.Text = ofd.FileName;
            }
        }

        public event PropertyChangedEventHandler PropertyChanged;

        private void OnPropertyChanged(string propertyName)
        {
            if (PropertyChanged != null) PropertyChanged(this, new PropertyChangedEventArgs(propertyName));
        }
    }
}
