﻿using System.Windows.Input;
using System.ComponentModel;

namespace PierwszaZrozumiałaAplikacjaMVVM.ModelWidoku
{
    using PierwszaZrozumiałaAplikacjaMVVM.Model;

    

    public class EdytorWartości : INotifyPropertyChanged
    {
        private StanAplikacji model = new StanAplikacji();

        public double Wartość
        {
            get
            {
                return model.Wartość;
            }
            set
            {
                model.Wartość = value;
                onPropertyChanged("Wartość");
                //System.Console.Beep(100, 100);
            }
        }

        public event PropertyChangedEventHandler PropertyChanged;

        private void onPropertyChanged(string nazwaWłasności)
        {
            if (PropertyChanged != null) 
                PropertyChanged(this, new PropertyChangedEventArgs(nazwaWłasności));
        }

        private ICommand resetuj;

        public ICommand Resetuj
        {
            get
            {
                resetuj = new MvvmCommand(
                    (object parameter) => { this.Wartość = 0; },
                    (object parameter) => { return this.Wartość > 0; }
                    );
                return resetuj;
            }
        }
    }
}
