﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace AsystentZakupów.Model
{
    public class AutoSumowanie
    {
        private decimal suma = 0;
        private decimal limit;

        public AutoSumowanie(decimal limit)
        {
            this.limit = limit;
        }

        public decimal Suma
        {
            get 
            {
                return suma;
            }
        }

        public bool CzyMożnaDodaćKwotę(decimal kwota)
        {
            return (kwota > 0) && !(suma + kwota > limit);
        }

        public void Dodaj(decimal kwota)
        {
            //if (kwota < 0) throw new ArgumentException("Ujemna kwota");
            //if (suma + kwota > limit) throw new ArgumentException("Przekroczenie limitu");
            if (!CzyMożnaDodaćKwotę(kwota)) throw new ArgumentException("Niepoprawna kwota");
            suma += kwota;
        }

        public override string ToString()
        {
            return Suma.ToString();
        }
    }
}
