﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Input;
using System.ComponentModel;

namespace AsystentZakupówWPF.ModelWidoku
{
    using AsystentZakupów.Model;    

    public class Sumowanie : INotifyPropertyChanged
    {
        private AutoSumowanie model = new AutoSumowanie(1000);

        public decimal Suma
        {
            get
            {
                return model.Suma;
            }
        }

        private ICommand dodajKwotę = null;

        public ICommand DodajKwotę
        {
            get
            {
                //if (dodajKwotę == null) dodajKwotę = new DodajKwotęCommand(model);
                if (dodajKwotę == null)
                    dodajKwotę = new MvvmCommand(
                        (object parameter) =>
                        {
                            decimal kwota = (decimal)parameter;
                            model.Dodaj(kwota);
                            onPropertyChanged("Suma");
                        },
                        (object parameter) =>
                        {
                            if (parameter == null) return false;
                            decimal kwota = (decimal)parameter;
                            return model.CzyMożnaDodaćKwotę(kwota);
                        }
                        );
                return dodajKwotę;
            }
        }

        public event PropertyChangedEventHandler PropertyChanged;

        private void onPropertyChanged(string nazwaWłasności)
        {
            if (PropertyChanged != null) PropertyChanged(this, new PropertyChangedEventArgs(nazwaWłasności));
        }
    }
}
