﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Input;

namespace AsystentZakupówWPF.ModelWidoku
{
    using AsystentZakupów.Model;

    class DodajKwotęCommand : ICommand
    {
        AutoSumowanie model;

        public DodajKwotęCommand(AutoSumowanie model)
        {
            this.model = model;
        }

        public bool CanExecute(object parameter)
        {
            try
            {
                if (parameter == null) return false;
                decimal kwota = (decimal)parameter;
                bool wynik = model.CzyMożnaDodaćKwotę(kwota);
                //if (wynik != canExecuteResult) onCanExecuteChanged();
                //canExecuteResult = wynik;
                return wynik;
            }
            catch(Exception exc)
            {
                return false;
            }
        }

        public event EventHandler CanExecuteChanged
        {
            add
            {
                CommandManager.RequerySuggested += value;
            }
            remove
            {
                CommandManager.RequerySuggested -= value;
            }
        }

        /*
        private bool canExecuteResult = false;
        public event EventHandler CanExecuteChanged;

        private void onCanExecuteChanged()
        {
            if (CanExecuteChanged != null) CanExecuteChanged(this, EventArgs.Empty);
        }
        */

        public void Execute(object parameter)
        {
            decimal kwota = (decimal)parameter;
            model.Dodaj(kwota);
        }
    }

    class MvvmCommand : ICommand
    {
        Action<object> execute;
        Predicate<object> canExecute;

        public MvvmCommand(Action<object> execute, Predicate<object> canExecute)
        {
            if (execute == null) throw new ArgumentNullException("execute");
            this.execute = execute;
            this.canExecute = canExecute;
        }

        public bool CanExecute(object parameter)
        {
            if (canExecute == null) return true;
            else return canExecute(parameter);
        }

        public event EventHandler CanExecuteChanged
        {
            add
            {
                CommandManager.RequerySuggested += value;
            }
            remove
            {
                CommandManager.RequerySuggested -= value;
            }
        }

        public void Execute(object parameter)
        {
            execute(parameter);
        }
    }
}
