﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

using System.Runtime.InteropServices;

namespace PInvoke
{    
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        private static double Round(double value, int decimals = 2)
        {
            //return (long)Math.Round((double)value, decimals);
            
            const double c = 100;
            return (Math.Round(c * value) / c);
        }

        private void button1_Click(object sender, EventArgs e)
        {
            WinAPI.MessageBeep(0);

            WinAPI.WinExec("notepad.exe", WinAPI.CmdShow.Maximized);

            long freeBytesAvailable, totalNumberOfBytes, totalNumberOfFreeBytes;
            WinAPI.GetDiskFreeSpaceEx(@"c:\", out freeBytesAvailable, out totalNumberOfBytes, out totalNumberOfFreeBytes);
            //string s = "" + freeBytesAvailable + "/" + totalNumberOfBytes + "/" + totalNumberOfFreeBytes;
            string s = Round(100.0 * totalNumberOfFreeBytes / totalNumberOfBytes).ToString(); 
            label1.Text = s + "%";

            //label2.Text = Environment.SystemDirectory;
            //label2.Text = Environment.GetEnvironmentVariable("windir");
            StringBuilder bufor = new StringBuilder();
            WinAPI.GetWindowsDirectory(bufor, WinAPI.MaxPath);
            label2.Text = bufor.ToString();
        }

        private void button2_Click(object sender, EventArgs e)
        {
            //WinAPI.SendMessage(this.Handle, 16, 0, 0);
            IntPtr uchwyt = WinAPI.FindWindow(null, "Kalkulator");
            MessageBox.Show("Uchwyt okna: " + uchwyt.ToString());
            //WinAPI.SendMessage(uchwyt, 16, 0, 0);
            WinAPI.SendMessage(Message.Create(uchwyt, 16, IntPtr.Zero, IntPtr.Zero));
        }

        protected override void WndProc(ref Message m)
        {
            if(m.Msg != 16) base.WndProc(ref m);

            if (m.Msg != 308)
            {
                listBox1.Items.Add(m.Msg.ToString());
            }
        }
    }

    public static class WinAPI
    {
        public enum CmdShow : uint { Hide = 0, Normal = 1, Minimized = 2, Maximized = 3 };

        public const int MaxPath = 260;

        [DllImport("user32.dll")]
        public static extern bool MessageBeep(uint uType);

        [DllImport("kernel32.dll")]
        public static extern uint WinExec(string cmdLine, CmdShow uCmdShow);

        [DllImport("kernel32.dll")]
        public static extern bool GetDiskFreeSpaceEx(
            string directoryName,
            out long freeBytesAvailable,
            out long totalNumberOfBytes,
            out long totalNumberOfFreeBytes);

        [DllImport("kernel32.dll")]        
        public static extern uint GetWindowsDirectory(
            StringBuilder buffer,
            uint uSize);

        
        [DllImport("user32.dll")]
        public static extern int SendMessage(IntPtr hWnd, uint msg, int wParam, int lParam);

        public static int SendMessage(Message m)
        {
            return SendMessage(m.HWnd, (uint)m.Msg, (int)m.WParam, (int)m.LParam);
        }

        [DllImport("user32.dll")]
        public static extern IntPtr FindWindow(string nazwaKlasy, string nazwaOkna);
    }
}
