﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace LINQ
{
    static class Rozszerzenia
    {
        public static void Drukuj<T>(this IEnumerable<T> kolekcja, bool noweLinie = false) //extension method, rozszerzenie
        {
            Console.WriteLine("Elementy kolekcji (N=" + kolekcja.Count() + "): ");
            foreach (T element in kolekcja)
            {
                if (element != null) Console.Write(element.ToString() + "; ");                
                else Console.Write("null; ");
                if (noweLinie) Console.WriteLine();
            }
            Console.WriteLine("");
        }

        public static IEnumerable<string> ToString<T>(this IEnumerable<T> kolekcja)
        {
            string[] łańcuchy = new string[kolekcja.Count()];
            foreach(T element in kolekcja) 
                yield return element.ToString();
        }
    }

    class Klasa
    {
        /*
        public void Drukuj<T>(IEnumerable<T> kolekcja)
        {
            Console.WriteLine("Elementy kolekcji (N=" + kolekcja.Count() + "): ");
            foreach (T element in kolekcja)
            {
                if (element != null) Console.Write(element.ToString() + "; ");
                else Console.Write("null; ");
            }
            Console.WriteLine("");
        }
        */

        

        public void Metoda1()
        {
            int[] liczby = new int[10];
            //Drukuj(liczby);
            //Rozszerzenia.Drukuj(liczby);
            liczby.Drukuj();
            for (int i = 0; i < liczby.Length; ++i)
                liczby[i] = i;
            liczby.Drukuj();

            IEnumerable<string> łańuchy2 = liczby.ToString<int>();
            łańuchy2.Drukuj();

            string[] łańcuchy = new string[10];
            liczby.Drukuj();
            for (int i = 0; i < łańcuchy.Length; ++i)
                łańcuchy[i] = i.ToString();
            liczby.Drukuj();

            double średnia = liczby.Average();
            Console.WriteLine("średnia: " + średnia.ToString());

            double suma = liczby.Sum();
            Console.WriteLine("suma: " + suma.ToString());

            Func<int, int, int> f = (int a1, int a2) =>
                {
                    //a1 = agregowana wartość
                    //a2 = bieżąca
                    //Console.WriteLine("a1=" + a1.ToString());
                    //Console.WriteLine("a2=" + a2.ToString());
                    return a1 + a2;
                };
            double _średnia = liczby.Aggregate(f);
            Console.WriteLine("Średnia: " + (_średnia/liczby.Count()).ToString());

            double średnia2 = łańcuchy.Average(s => s.Length);
            Console.WriteLine("średnia: " + średnia2.ToString());

            IEnumerable<string> wynik = from liczba in liczby
                                        where liczba % 2 == 0
                                        orderby liczba descending
                                        select liczba.ToString() + "*";

            wynik.Drukuj();

            var wynik2 = liczby.Where(liczba => liczba % 2 == 0).OrderByDescending(liczba => liczba).Select(liczba => liczba.ToString() + "*");

            wynik2.Drukuj();
        }

        class Osoba
        {
            public string Imię;
            public string Nazwisko;
            public int Wiek;

            public override string ToString()
            {
                return Imię + " " + Nazwisko + " (" + Wiek.ToString() + ")";
            }
        }

        public void Metoda()
        {
            List<Osoba> osoby = new List<Osoba>();
            osoby.Add(new Osoba() { Imię = "Jacek", Nazwisko = "Matulewski", Wiek = 44 });
            osoby.Add(new Osoba() { Imię = "Katarzyna", Nazwisko = "Matulewska", Wiek = 45 });
            osoby.Add(new Osoba() { Imię = "Karolina", Nazwisko = "Matulewska", Wiek = 16 });
            osoby.Add(new Osoba() { Imię = "Paweł", Nazwisko = "Danieluk", Wiek = 21 });
            osoby.Add(new Osoba() { Imię = "Damian", Nazwisko = "Tomaszewski", Wiek = 21 });
            osoby.Add(new Osoba() { Imię = "Radek", Nazwisko = "Gatyński", Wiek = 24 });

            //1 osoby starsze niż 40 posortowane wg. imion
            var wynik = from osoba in osoby
                        where osoba.Wiek > 40
                        orderby osoba.Imię
                        select osoba;
            wynik.Drukuj();

            wynik.ElementAt(0).Wiek = 100; //Ważne!!!: zapytanie kopiuje referencje, a nie klonuje obiekty ze źródła
            wynik.Drukuj();
            osoby.Drukuj();            

            //2 kobiety posrotwane wg wieku
            var wynik2 = from osoba in osoby
                         where osoba.Imię[osoba.Imię.Length - 1] == 'a'
                         orderby osoba.Wiek
                         select osoba;
            wynik2.Drukuj(true);

            //3 mężczyźni z nazwiskiem dłuższym niż 8 liter
            var wynik3 = from osoba in osoby
                         //where osoba.Imię[osoba.Imię.Length - 1] != 'a' && osoba.Nazwisko.Length > 8
                         where osoba.Imię[osoba.Imię.Length - 1] != 'a'
                         where osoba.Nazwisko.Length > 8
                         select osoba;
            wynik3.Drukuj(true);
        }
    }


    class Program
    {
        static void Main(string[] args)
        {
            Klasa obiekt = new Klasa();
            obiekt.Metoda();
            obiekt = null; //zwolnienie referencji
            GC.Collect(); //niepolecane

            //dalszy kod
        }
    }
}
