﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using System.IO;

namespace Kontrolka
{
    public partial class FileChooser : UserControl
    {
        public FileChooser()
        {
            InitializeComponent();

            this.MinimumSize = new Size(0, Height);
            this.MaximumSize = new Size(10000, Height);
        }

        [Category("Umk")]
        [Description("Zdefiniowane")]
        public string FilePath 
        { 
            get
            {
                return textBox.Text;
            }
            set
            {
                if (!string.IsNullOrEmpty(value) && !File.Exists(value)) throw new FileNotFoundException("Plik " + value + " nie istnieje");
                textBox.Text = value;
                OnFilePathChanged();
            }
        }

        [Category("Umk")]
        public string Filter
        {
            get
            {
                return openFileDialog.Filter;
            }
            set
            {
                openFileDialog.Filter = value;
            }
        }

        [Category("Umk")]
        public int FilterIndex
        {
            get
            {
                return openFileDialog.FilterIndex;
            }
            set
            {
                openFileDialog.FilterIndex = value;
            }
        }

        private void button1_Click(object sender, EventArgs e)
        {
            openFileDialog.FileName = textBox.Text;
            if(openFileDialog.ShowDialog() == DialogResult.OK)
            {
                //textBox.Text = openFileDialog.FileName;
                FilePath = openFileDialog.FileName;
            }
        }

        #region Zdarzenie
        public class FilePathEventArgs : EventArgs
        {
            public string FilePath;            
        }

        //public delegate void FilePathChangedHandler(object sender, EventArgs e);
        public delegate void FilePathChangedHandler(object sender, FilePathEventArgs e);

        [Category("Umk")]
        public event FilePathChangedHandler FilePathChanged;
        //public event Action<object,FilePathEventArgs> FilePathChanged;

        private void OnFilePathChanged()
        {
            if (FilePathChanged != null) FilePathChanged(this, new FilePathEventArgs() { FilePath = this.FilePath });
        }
        #endregion
    }
}
