﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace Delegacje
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();

            button2.Click += (object sender, EventArgs e) => { MessageBox.Show(sender.GetType().Name); };

            //button2.Click(null, EventArgs.Empty);
        }

        int kwadrat(int arg)
        {
            return arg * arg;
        }

        int sześcian(int arg)
        {
            return kwadrat(arg) * arg;
        }

        public delegate int FunkcjaPotęgowa(int arg); //delegacja = typ referencji do metody

        public /*event*/ FunkcjaPotęgowa f0;

        private void button1_Click(object sender, EventArgs e)
        {
            /*
            int wynik = kwadrat(2);
            MessageBox.Show("2^2 = " + wynik);

            wynik = sześcian(2);
            MessageBox.Show("2^3 = " + wynik);

            FunkcjaPotęgowa f2 = kwadrat;
            FunkcjaPotęgowa f3 = sześcian; //instancja delegacji
            if (f2 == f3) MessageBox.Show("f2 = f3");
            MessageBox.Show("f2 != f3");

            wynik = f2(2);
            MessageBox.Show("ref 2^2 = " + wynik);

            wynik = f3(2);
            MessageBox.Show("ref 2^3 = " + wynik);

            Func<int, int> f22 = kwadrat;
            wynik = f22(2);
            MessageBox.Show("ref 2^2 = " + wynik);

            Func<int, int> f32 = (int arg) => { return arg * arg; }; //wyrażenie Lambda
            wynik = f22(2);
            MessageBox.Show("ref 2^2 = " + wynik);

            Func<int, int> f42 = arg => arg * arg;
            wynik = f22(2);
            MessageBox.Show("ref 2^2 = " + wynik);
            */

            f0 = arg => arg * arg;
            int wynik2 = f0(2);
            MessageBox.Show("2^2 = " + wynik2);
        }

        private void button2_Click(object sender, EventArgs e)
        {
            Inna inna = new Inna(this);
            inna.Kwadratuj();
        }
    }

    class Inna
    {
        Form1 form;

        public Inna(Form1 form)
        {
            this.form = form;
        }

        public void Kwadratuj()
        {
            form.f0 += (Form1.FunkcjaPotęgowa)((int arg) => { MessageBox.Show(2.ToString()); return arg * arg; });
            form.f0 += (Form1.FunkcjaPotęgowa)((int arg) => { MessageBox.Show(3.ToString()); return arg * arg * arg; });
            int wynik2 = form.f0(2);
            MessageBox.Show("2^3 = " + wynik2);
        }
    }
}
