﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace DragNDrop
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();

            for(int i = 0; i < 10; ++i)
            {
                listBox1.Items.Add("Lista 1, pozycja " + i.ToString());
                listBox2.Items.Add("Lista 2, pozycja " + i.ToString());
            }
        }

        #region Obsługa drag & drop
        ListBox lbSource = null;

        private void listBox1_MouseDown(object sender, MouseEventArgs e)
        {
            ListBox lbSender = sender as ListBox;
            lbSource = lbSender;
            listBox1.DoDragDrop(lbSender.SelectedItem, DragDropEffects.Copy | DragDropEffects.Move);
        }

        private void listBox2_DragOver(object sender, DragEventArgs e)
        {
            if((e.KeyState & 8) == 8) e.Effect = DragDropEffects.Copy;
            else e.Effect = DragDropEffects.Move;
        }

        private void listBox2_DragDrop(object sender, DragEventArgs e)
        {
            ListBox lbSender = sender as ListBox;            
            int indeks = lbSender.IndexFromPoint(lbSender.PointToClient(new Point(e.X, e.Y)));
            if(indeks >= 0) lbSender.Items.Insert(indeks, lbSource.SelectedItem);
            else lbSender.Items.Add(lbSource.SelectedItem);
            if (e.Effect == DragDropEffects.Move) lbSource.Items.Remove(lbSource.SelectedItem);
        }
        #endregion
    }
}
