﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace Notatnik.NET
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        private void nowyToolStripMenuItem_Click(object sender, EventArgs e)
        {
            bool czyUsunąć = true;
            if (!string.IsNullOrEmpty(textBox1.Text))
            {
                DialogResult dr = MessageBox.Show(
                    "Czy jesteś pewien, że chcesz usunąć bieżący tekst?",
                    Text,
                    MessageBoxButtons.YesNo,
                    MessageBoxIcon.Question);
                czyUsunąć = dr == DialogResult.Yes;
            }
            if(czyUsunąć) textBox1.Clear();
        }

        private string _ścieżkaPliku = null;
        
        private string ścieżkaPliku
        {
            get
            {
                return _ścieżkaPliku;
            }
            set
            {
                _ścieżkaPliku = value;
                toolStripStatusLabel1.Text = _ścieżkaPliku;
            }
        }

        private void otwórzToolStripMenuItem_Click(object sender, EventArgs e)
        {
            openFileDialog1.FileName = ścieżkaPliku;
            if(openFileDialog1.ShowDialog() == DialogResult.OK)
            {
                textBox1.Lines = File.ReadAllLines(openFileDialog1.FileName);
                ścieżkaPliku = openFileDialog1.FileName;                
                tylkoDoOdczytuToolStripMenuItem.Checked = openFileDialog1.ReadOnlyChecked;
            }
        }

        private void zapiszJakoToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (saveFileDialog1.ShowDialog() == DialogResult.OK)
            {
                File.WriteAllLines(saveFileDialog1.FileName, textBox1.Lines);
                ścieżkaPliku = saveFileDialog1.FileName;
            }
            
        }

        private void tylkoDoOdczytuToolStripMenuItem_CheckedChanged(object sender, EventArgs e)
        {
            textBox1.ReadOnly = tylkoDoOdczytuToolStripMenuItem.Checked;
        }

        private void zakończToolStripMenuItem_Click(object sender, EventArgs e)
        {
            Close();
        }

        private void Form1_FormClosing(object sender, FormClosingEventArgs e)
        {
            //ZADANIE DOMOWE - DODAC OKNO MessageBox PYTAJACE O ZAPISANIE DO PLIKU YesNoCancel
        }

        private void toolStripMenuItem5_Click(object sender, EventArgs e)
        {
            textBox1.Undo();
        }

        private void wytnijToolStripMenuItem_Click(object sender, EventArgs e)
        {
            textBox1.Cut();
        }

        private void kopiujToolStripMenuItem_Click(object sender, EventArgs e)
        {
            textBox1.Copy();
        }

        private void wklejToolStripMenuItem_Click(object sender, EventArgs e)
        {
            textBox1.Paste();
        }

        private void zaznaczWszystkoToolStripMenuItem_Click(object sender, EventArgs e)
        {
            textBox1.SelectAll();
        }

        private void usuńToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (textBox1.SelectedText == "")
                textBox1.Select(textBox1.SelectionStart, 1);
            textBox1.SelectedText = "";
        }

        private void godzinaDataToolStripMenuItem_Click(object sender, EventArgs e)
        {
            textBox1.SelectedText = DateTime.Now.ToString();
        }

        private void zawijanieWierszyToolStripMenuItem_CheckedChanged(object sender, EventArgs e)
        {
            textBox1.WordWrap = zawijanieWierszyToolStripMenuItem.Checked;
        }

        private void pasekStanuToolStripMenuItem_CheckedChanged(object sender, EventArgs e)
        {
            statusStrip1.Visible = pasekStanuToolStripMenuItem.Checked;
        }
    }
}
