﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace AplikacjaWinForms
{
    using Model;

    public partial class Form1 : Form
    {
        private Kolor model;

        public Form1()
        {
            InitializeComponent();

            //TODO: czytanie
            model = DAL.Czytaj();
            aktualizujWidok(true);
        }

        private static string toHex(byte v)
        {
            string s = v.ToString("X");
            if (s.Length < 2) s = "0" + s;
            return s;            
        }

        private bool czyAktualizowaćKolorPanelu = true;

        private void aktualizujWidok(bool czySuwakiTakże)
        {
            if(czySuwakiTakże)
            {
                czyAktualizowaćKolorPanelu = false;
                trackBarR.Value = model.R;
                trackBarG.Value = model.G;
                trackBarB.Value = model.B;
                czyAktualizowaćKolorPanelu = true;
            }

            panel1.BackColor = model.ToColor();

            textBox1.Text = "#" +
                toHex(model.R) +
                toHex(model.G) +
                toHex(model.B);
        }

        #region controller
        private void trackBar1_ValueChanged(object sender, EventArgs e)
        {
            if (!czyAktualizowaćKolorPanelu) return;

            model.R = (byte)trackBarR.Value;
            model.G = (byte)trackBarG.Value;
            model.B = (byte)trackBarB.Value;
            aktualizujWidok(false);
        }

        private void button1_Click(object sender, EventArgs e)
        {
            //Clipboard.SetText(textBox1.Text);
            textBox1.SelectAll();
            textBox1.Copy();
        }

        private void button2_Click(object sender, EventArgs e)
        {
            model.Resetuj();
            aktualizujWidok(true);
        }

        private void button3_Click(object sender, EventArgs e)
        {
            colorDialog1.Color = panel1.BackColor;
            if (colorDialog1.ShowDialog() == DialogResult.OK)
            {
                model = colorDialog1.Color.ToKolor();
                aktualizujWidok(true);
            }
        }
        #endregion

        private void Form1_FormClosing(object sender, FormClosingEventArgs e)
        {
            bool czyNiePytaćOPotwierdzenie =
                trackBarR.Value == Properties.Settings.Default.R &&
                trackBarG.Value == Properties.Settings.Default.G &&
                trackBarB.Value == Properties.Settings.Default.B;

            if (!czyNiePytaćOPotwierdzenie)
            {
                DialogResult dr = MessageBox.Show("Czy na pewno chcesz zamknąć aplikację?", Text, MessageBoxButtons.YesNo, MessageBoxIcon.Question, MessageBoxDefaultButton.Button2);
                if (dr == DialogResult.No) e.Cancel = true;
            }
        }

        private void Form1_FormClosed(object sender, FormClosedEventArgs e)
        {
            DAL.Zapisz(model);

            for (; Opacity > 0; Opacity -= 0.01)
            {
                System.Threading.Thread.Sleep(10);                
            }
        }
    }

    static class KolorHelper
    {
        public static Color ToColor(this Kolor model)
        {
            return Color.FromArgb(model.R, model.G, model.B);
        }

        public static Kolor ToKolor(this Color color)
        {
            return new Kolor() { R = color.R, G = color.G, B = color.B };
        }
    }
}
