﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace AplikacjaWinForms
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();

            czyAktualizowaćKolorPanelu = false;
            trackBarR.Value = Properties.Settings.Default.R;
            trackBarG.Value = Properties.Settings.Default.G;
            trackBarB.Value = Properties.Settings.Default.B;
            czyAktualizowaćKolorPanelu = true;

            trackBar1_ValueChanged(null, EventArgs.Empty);
        }

        private string toHex(byte v)
        {
            string s = v.ToString("X");
            //int l = s.Length;
            //for (int i = 0; i < 2 - l; ++i) s = "0" + s;
            if (s.Length < 2) s = "0" + s;
            return s;            
        }

        private bool czyAktualizowaćKolorPanelu = true;

        private void trackBar1_ValueChanged(object sender, EventArgs e)
        {
            if (!czyAktualizowaćKolorPanelu) return;

            panel1.BackColor = Color.FromArgb(
                trackBarR.Value,
                trackBarG.Value,
                trackBarB.Value);
            /*
            textBox1.Text =
                trackBar1.Value + " " +
                trackBar2.Value + " " +
                trackBar3.Value;
            */
            textBox1.Text = "#" + 
                toHex((byte)trackBarR.Value) +
                toHex((byte)trackBarG.Value) +
                toHex((byte)trackBarB.Value);
        }

        private void button1_Click(object sender, EventArgs e)
        {
            //Clipboard.SetText(textBox1.Text);
            textBox1.SelectAll();
            textBox1.Copy();
        }

        private void Form1_FormClosing(object sender, FormClosingEventArgs e)
        {
            bool czyNiePytaćOPotwierdzenie =
                trackBarR.Value == Properties.Settings.Default.R &&
                trackBarG.Value == Properties.Settings.Default.G &&
                trackBarB.Value == Properties.Settings.Default.B;

            if (!czyNiePytaćOPotwierdzenie)
            {
                DialogResult dr = MessageBox.Show("Czy na pewno chcesz zamknąć aplikację?", Text, MessageBoxButtons.YesNo, MessageBoxIcon.Question, MessageBoxDefaultButton.Button2);
                if (dr == DialogResult.No) e.Cancel = true;
            }
        }

        private void Form1_FormClosed(object sender, FormClosedEventArgs e)
        {
            Properties.Settings.Default.R = (byte)trackBarR.Value;
            Properties.Settings.Default.G = (byte)trackBarG.Value;
            Properties.Settings.Default.B = (byte)trackBarB.Value;
            Properties.Settings.Default.Save();
        }
    }
}
