﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace AsystentZakupów.Model
{
    public class AutoSumowanie
    {
        private decimal suma = 0;
        private decimal limit;

        public AutoSumowanie(decimal limit)
        {
            this.limit = limit;
        }

        public decimal Suma
        {
            get 
            {
                return suma;
            }
        }

        public void Dodaj(decimal kwota)
        {
            if (kwota < 0) throw new ArgumentException("Ujemna kwota");
            if (suma + kwota > limit) throw new ArgumentException("Przekroczenie limitu");
            suma += kwota;
        }

        public override string ToString()
        {
            return Suma.ToString();
        }
    }
}
