﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

namespace CsvDocumentDemo
{
    using LinqToCsv;
    
    /// <summary>
    /// Interaction logic for MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window
    {
        public MainWindow()
        {
            InitializeComponent();
        }

        private static List<Osoba> listaOsób = new List<Osoba>()
        {
            new Osoba() { Id = 0, Imię = "Jacek", Nazwisko = "Matulewski", NumerTelefonu = 123456789, Wiek = 44 },
            new Osoba() { Id = 1, Imię = "Bilbo", Nazwisko = "Baggins", NumerTelefonu = 27834628, Wiek = 133 },
            new Osoba() { Id = 2, Imię = "Frodo", Nazwisko = "Baggins", NumerTelefonu = 27834628, Wiek = 40 },
            new Osoba() { Id = 3, Imię = "Katarzyna", Nazwisko = "Matulewska", NumerTelefonu = 732673264, Wiek = 45 },
            new Osoba() { Id = 4, Imię = "Róża", Nazwisko = "Matulewska", Wiek = 13 }
        };

        class Osoba
        {
            public int Id;
            public string Imię, Nazwisko;
            public int NumerTelefonu, Wiek;

            public override string ToString()
            {
                return Imię + " " + Nazwisko + " (" + Wiek + ")";
            }
        }

        class CsvOsoba : ICsvRecord
        {
            public int Id;
            public string Imię, Nazwisko;
            public int NumerTelefonu, Wiek;

            public override string ToString()
            {
                return Imię + " " + Nazwisko + " (" + Wiek + ")";
            }

            public void ParseValues(string[] values, IFormatProvider formatProvider)
            {
                Id = int.Parse(values[0].Trim(), formatProvider);
                Imię = values[1].Trim();
                Nazwisko = values[2].Trim();
                if (string.IsNullOrWhiteSpace(values[3])) NumerTelefonu = -1;
                else NumerTelefonu = int.Parse(values[3].Trim(), formatProvider);
                Wiek = int.Parse(values[4].Trim(), formatProvider);
            }

            public string[] ToValues(IFormatProvider formatProvider)
            {
                string[] values = new string[5];
                values[0] = Id.ToString(formatProvider);
                values[1] = Imię;
                values[2] = Nazwisko;
                values[3] = NumerTelefonu == -1 ? "" : NumerTelefonu.ToString(formatProvider);
                values[4] = Wiek.ToString(formatProvider);
                return values;
            }
        }

        private void button_Click(object sender, RoutedEventArgs e)
        {
            CsvDocument<CsvOsoba> csv = CsvDocument<CsvOsoba>.Load("listaOsób.csv", ';', (CsvOsoba o) => { return o.Wiek > 100; });
            csv.AddRecord(new CsvOsoba() { Id = 5, Imię = "Smaug", Nazwisko = "Smok", NumerTelefonu = 123, Wiek = 1000 });
            csv.SaveAs("kopia.csv",';');

            var zapytanie = from CsvOsoba osoba in csv
                            where osoba.Wiek > 30
                            orderby osoba.Wiek
                            select osoba.ToString();

            string s = "";
            foreach (string linia in zapytanie) s += linia + "\n";
            MessageBox.Show(s);

            int sumaWieków = csv.Sum(osoba => osoba.Wiek);
            MessageBox.Show(sumaWieków.ToString());
        }

        private void button1_Click(object sender, RoutedEventArgs e)
        {
            IEnumerable<CsvAutoRecord<Osoba>> records = listaOsób.Select(osoba => new CsvAutoRecord<Osoba>(osoba));
            CsvDocument<CsvAutoRecord<Osoba>> csv = new CsvDocument<CsvAutoRecord<Osoba>>(records);
        }

        private void button2_Click(object sender, RoutedEventArgs e)
        {
            CsvDocument<CsvAutoRecord<Osoba>> csv = CsvDocument<CsvAutoRecord<Osoba>>.Load("listaOsób1.csv", ';');
            csv.AddRecord(new CsvAutoRecord<Osoba>(new Osoba() { Id = 5, Imię = "Smaug", Nazwisko = "Smok", NumerTelefonu = 123, Wiek = 1000 }));
            csv.SaveAs("kopia.csv", ';');

            var zapytanie = from CsvAutoRecord<Osoba> record in csv
                            let osoba = record.Value
                            where osoba.Wiek > 30
                            orderby osoba.Wiek
                            select osoba.ToString();

            string s = "";
            foreach (string linia in zapytanie) s += linia + "\n";
            MessageBox.Show(s);

            int sumaWieków = csv.Sum(osoba => osoba.Value.Wiek);
            MessageBox.Show(sumaWieków.ToString());
        }

        private void button3_Click(object sender, RoutedEventArgs e)
        {
            //IEnumerable<CsvOsoba> csv = CsvDocument<CsvOsoba>.Load("listaOsób.csv", ';', (CsvOsoba o) => { return o.Wiek > 100; });
            IQueryable<CsvOsoba> csv = new CsvDocumentQueryable<CsvOsoba>("listaOsób.csv", ';');
            //csv.AddRecord(new CsvOsoba() { Id = 5, Imię = "Smaug", Nazwisko = "Smok", NumerTelefonu = 123, Wiek = 1000 });
            //csv.SaveAs("kopia.csv", ';');

            var zapytanie = from CsvOsoba osoba in csv
                            where osoba.Wiek > 30
                            orderby osoba.Wiek
                            select osoba;

            /*
            var zapytanie1 = from CsvOsoba osoba in csv
                            where osoba.Wiek > 30
                            orderby osoba.Wiek
                            select osoba.ToString();
            */

            string s = "";
            foreach (CsvOsoba linia in zapytanie) s += linia.ToString() + "\n";
            MessageBox.Show(s);
        }
    }
}
