﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.Runtime.InteropServices;


namespace PInvokeCS
{
    using HWND = IntPtr;

    public static class WinAPI
    {
        [DllImport("user32.dll")]
        [return: MarshalAs(UnmanagedType.Bool)]
        public static extern bool MessageBeep(uint rodzajDźwięku);

        [DllImport("user32.dll", EntryPoint="MessageBox", CharSet=CharSet.Unicode)]
        public static extern int _MessageBox(IntPtr hWnd, string text, string caption = "", uint type = 0);

        public enum StanOkna : int { Ukryte = 0, Normalne = 1, Zminimalizowane, Maksymalizowane, Nieaktywne, Domyślne = 10};

        [DllImport("kernel32.dll")]
        public static extern uint WinExec(string polecenie, StanOkna okna);

        //ref lub out
        [DllImport("kernel32.dll")]
        public static extern bool GetDiskFreeSpaceEx(
            string katalog,
            out long wolneMiejsceDlaUżytkownika,
            out long rozmiarDysku,
            out long wolneMiejsceNaDysku);

        [StructLayout(LayoutKind.Sequential)]
        public struct RECT 
        {
            public int Left;
            public int Top;
            public int Right;
            public int Bottom;

            public int Width
            {
                get
                {
                    return Right - Left;
                }
            }

            public int Height
            {
                get
                {
                    return Bottom - Top;
                }
            }
        }

        [DllImport("user32.dll")]
        public static extern bool GetWindowRect(IntPtr hWnd, out RECT rect);

        [DllImport("user32.dll")]
        public static extern HWND GetDesktopWindow();

        [DllImport("user32.dll")]
        public static extern bool SetWindowText(IntPtr hWnd, string text);

        [DllImport("user32.dll")]
        public static extern int SendMessage(IntPtr hWnd, uint msg, IntPtr wParam, IntPtr lParam);

        [DllImport("user32.dll")]
        public static extern HWND FindWindow(string klasa, string tytuł);
    }
}
