﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

namespace CsvDocumentDemo
{
    using LinqToCsv;
    
    /// <summary>
    /// Interaction logic for MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window
    {
        public MainWindow()
        {
            InitializeComponent();
        }

        /*
        private static List<Osoba> listaOsób = new List<Osoba>()
        {
            new Osoba() { Id = 0, Imię = "Jacek", Nazwisko = "Matulewski", NumerTelefonu = 123456789, Wiek = 44 },
            new Osoba() { Id = 1, Imię = "Bilbo", Nazwisko = "Baggins", NumerTelefonu = 27834628, Wiek = 133 },
            new Osoba() { Id = 2, Imię = "Frodo", Nazwisko = "Baggins", NumerTelefonu = 27834628, Wiek = 40 },
            new Osoba() { Id = 3, Imię = "Katarzyna", Nazwisko = "Matulewska", NumerTelefonu = 732673264, Wiek = 45 },
            new Osoba() { Id = 4, Imię = "Róża", Nazwisko = "Matulewska", Wiek = 13 }
        };
        */

        /*
        class Osoba
        {
            public int Id;
            public string Imię, Nazwisko;
            public int NumerTelefonu, Wiek;

            public override string ToString()
            {
                return Imię + " " + Nazwisko + " (" + Wiek + ")";
            }
        }
        */

        class CsvOsoba : ICsvRecord
        {
            public int Id;
            public string Imię, Nazwisko;
            public int NumerTelefonu, Wiek;

            public override string ToString()
            {
                return Imię + " " + Nazwisko + " (" + Wiek + ")";
            }

            public void ParseValues(string[] values)
            {
                Id = int.Parse(values[0].Trim());
                Imię = values[1].Trim();
                Nazwisko = values[2].Trim();
                if (string.IsNullOrWhiteSpace(values[3])) NumerTelefonu = -1;
                else NumerTelefonu = int.Parse(values[3].Trim());
                Wiek = int.Parse(values[4].Trim());
            }

            public string[] ToValues(string line)
            {
                throw new NotImplementedException();
            }
        }

        private void button_Click(object sender, RoutedEventArgs e)
        {
            CsvDocument<CsvOsoba> csv = CsvDocument<CsvOsoba>.Load("listaOsób.csv", ';');
        }
    }
}
