﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using System.Xml.Linq;

namespace LINQtoXML_Zajęcia
{
    /// <summary>
    /// Interaction logic for MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window
    {
        class Osoba
        {
            public int Id;
            public string Imię, Nazwisko;
            public int NumerTelefonu, Wiek;

            public override string ToString()
            {
                return Imię + " " + Nazwisko + " (" + Wiek + ")";
            }
        }

        private static List<Osoba> listaOsób = new List<Osoba>()
        {
            new Osoba() { Id = 0, Imię = "Jacek", Nazwisko = "Matulewski", NumerTelefonu = 123456789, Wiek = 44 },
            new Osoba() { Id = 1, Imię = "Bilbo", Nazwisko = "Baggins", NumerTelefonu = 27834628, Wiek = 133 },
            new Osoba() { Id = 2, Imię = "Frodo", Nazwisko = "Baggins", NumerTelefonu = 27834628, Wiek = 40 },
            new Osoba() { Id = 3, Imię = "Katarzyna", Nazwisko = "Matulewska", NumerTelefonu = 732673264, Wiek = 45 },
            new Osoba() { Id = 4, Imię = "Róża", Nazwisko = "Matulewska", Wiek = 13 }
        };


        public MainWindow()
        {
            InitializeComponent();
            czytajUstawieniaOkna();
        }

        const string ścieżkaPliku = "okno.xml";

        private void Window_Closed(object sender, EventArgs e)
        {
            /*
            XDocument xml = new XDocument(
                new XDeclaration("1.0", "UTF-8", "yes"),
                new XComment("Plik utworzony na kursie .NET dla zaawansowanych"),
                new XElement("ustawienia",
                    new XElement("okno",
                        new XAttribute("nazwa", this.Title),
                        new XElement("pozycja",
                            new XElement("X", this.Left),
                            new XElement("Y", this.Top)
                        ),
                        new XElement("rozmiar",
                            new XElement("W", this.Width),
                            new XElement("H", this.Height)
                        )
                    )
                )
            );
            */
            XDocument xml = new XDocument(
                new XDeclaration("1.0", "UTF-8", "yes"),
                new XComment("Plik utworzony na kursie .NET dla zaawansowanych"),
                new XElement("ustawienia")                    
            );
            XElement pozycja = new XElement("pozycja");
            pozycja.Add(new XElement("X", this.Left));
            pozycja.Add(new XElement("Y", this.Top));
            XElement rozmiar = new XElement("rozmiar");            
            rozmiar.Add(new XElement("W", this.Width));
            rozmiar.Add(new XElement("H", this.Height));
            xml.Root.Add(new XElement("okno"));
            xml.Root.Element("okno").Add(new XAttribute("nazwa", this.Title));
            xml.Root.Element("okno").Add(pozycja);
            xml.Root.Element("okno").Add(rozmiar);
            xml.Save(ścieżkaPliku);
        }

        private void czytajUstawieniaOkna()
        {
            if (!System.IO.File.Exists(ścieżkaPliku))
                MessageBox.Show("Pierwsze uruchomienie programu", Title, MessageBoxButton.OK, MessageBoxImage.Information);
            else
            {
                XDocument xml = XDocument.Load(ścieżkaPliku);
                try
                {
                    this.Title = xml.Root.Element("okno").Attribute("nazwa").Value;
                    this.Left = double.Parse(xml.Root.Element("okno").Element("pozycja").Element("X").Value);
                    this.Top = double.Parse(xml.Root.Element("okno").Element("pozycja").Element("Y").Value);
                    this.Width = double.Parse(xml.Root.Element("okno").Element("rozmiar").Element("W").Value);
                    this.Height = double.Parse(xml.Root.Element("okno").Element("rozmiar").Element("H").Value);
                }
                catch (Exception exc)
                {
                    MessageBox.Show(exc.Message, Title, MessageBoxButton.OK, MessageBoxImage.Error);
                }
            }
        }

        private void DodajElementDoWęzła(XElement elementXml, TreeViewItem węzełDrzewa, int poziom)
        {
            poziom++;

            IEnumerable<XElement> elementy = elementXml.Elements();
            foreach(XElement element in elementy)
            {
                string opis = element.Name.LocalName;
                if (!element.HasElements) opis += $" ({element.Value.Trim(' ','\n')})";
                TreeViewItem nowyWęzeł = new TreeViewItem()
                {
                    Header = opis,
                    IsExpanded = true
                };
                węzełDrzewa.Items.Add(nowyWęzeł);
                DodajElementDoWęzła(element, nowyWęzeł, poziom);
            }
        }

        private void button_Click(object sender, RoutedEventArgs e)
        {
            //XDocument xml = XDocument.Load(ścieżkaPliku);
            //XDocument xml = XDocument.Load("..\\..\\MainWindow.xaml");
            XDocument xml = XDocument.Load("http://www.nbp.pl/kursy/xml/LastC.xml");
            TreeViewItem węzełGłówny = new TreeViewItem()
            {
                Header = xml.Root.Name.LocalName,
                IsExpanded = true
            };
            treeView.Items.Add(węzełGłówny);

            treeView.BeginInit();
            DodajElementDoWęzła(xml.Root, węzełGłówny, 0);
            treeView.EndInit();
        }
    }
}
