﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace LinqToCsv
{
    public class CsvException : Exception
    {
        public CsvException(string message, Exception innerException = null)
            :base(message, innerException)
        {
        }
    }

    public interface ICsvRecord
    {
        string ParseValues(string[] values);
        string[] ToValues(string line);
    }

    public class CsvDocument<T> //:IEnumerable<T>
        where T : ICsvRecord, new()
    {
        protected List<T> records = new List<T>();

        public int Count
        {
            get
            {
                return records.Count;
            }
        }

        public T[] GetRecords()
        {
            return records.ToArray();
        }

        public CsvDocument(IEnumerable<T> records = null)
        {
            //this.records.Clear();
            if (records != null) this.records.AddRange(records);
        }

        private static bool TryParseRecordSecured(ref T record, string line, char separatorChar)
        {
            try
            {
                string[] strings = line.Split(separatorChar);
                record.ParseValues(strings);
                return true;
            }
            catch(Exception exc)
            {
                return false;
            }
        }

        public static CsvDocument<T> Load(string ścieżkaPliku, char separatorChar)
        {
            CsvDocument<T> csv = new CsvDocument<T>();
            using (StreamReader sr = new StreamReader(ścieżkaPliku))
            {
                string line;
                while((line = sr.ReadLine()) != null)
                {
                    T record = new T();
                    if (TryParseRecordSecured(ref record, line, separatorChar))
                        csv.records.Add(record);
                    else throw new CsvException("Błąd podczas parsowania linii " + line);
                }
            }
            return csv;
        }
    }
}
