﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace ZaawansowanyLINQ
{
    class Program
    {
        class Osoba
        {
            public int Id;
            public string Imię, Nazwisko;
            public int NumerTelefonu, Wiek;

            public override string ToString()
            {
                return Imię + " " + Nazwisko + " (" + Wiek + ")";
            }
        }

        private static List<Osoba> listaOsób = new List<Osoba>()
        {
            new Osoba() { Id = 0, Imię = "Jacek", Nazwisko = "Matulewski", NumerTelefonu = 123456789, Wiek = 44 },
            new Osoba() { Id = 1, Imię = "Bilbo", Nazwisko = "Baggins", NumerTelefonu = 27834628, Wiek = 133 },
            new Osoba() { Id = 2, Imię = "Frodo", Nazwisko = "Baggins", NumerTelefonu = 27834628, Wiek = 40 },
            new Osoba() { Id = 3, Imię = "Katarzyna", Nazwisko = "Matulewska", NumerTelefonu = 732673264, Wiek = 45 },
            new Osoba() { Id = 4, Imię = "Róża", Nazwisko = "Matulewska", Wiek = 13 }
        };

        static void Main(string[] args)
        {
            //let
            var listaOsóbPełnoletnich1 = from Osoba osoba in listaOsób
                                         let wiek = osoba.Wiek //lokalna zmienna o nazwie wiek
                                         let personalia = osoba.Imię + " " + osoba.Nazwisko
                                         where wiek >= 18 && wiek < 80
                                         orderby wiek, osoba.Nazwisko
                                         select wiek;

            var listaOsóbPełnoletnich2 = from Osoba osoba in listaOsób
                                         let personalia = osoba.Imię + " " + osoba.Nazwisko
                                         where personalia.Length < 20
                                         orderby personalia.Reverse()
                                         select personalia;

            //tego raczej nie należy używać
            var listaOsóbPełnoletnich3 = from Osoba osoba in listaOsób
                                         where osoba.Wiek >= 18
                                         select osoba.Imię + " " + osoba.Nazwisko
                                         into s
                                         where s.Length < 20
                                         orderby s descending
                                         select s;

            //Skip, SkipWhile, Take, TakeWhile
            var listaOsóbPełnoletnich4 = from Osoba osoba in listaOsób.SkipWhile(osoba => osoba.Imię != "Frodo")
                                         select osoba.ToString();

            string output = "";
            foreach (string element in listaOsóbPełnoletnich4) output += element + "\n";
            Console.WriteLine(output);

            //SelectMany
            var listaGrupPoNazwiskach = from Osoba osoba in listaOsób
                                         group osoba by osoba.Nazwisko into grupaNazwisko
                                         select grupaNazwisko;

            output = "";
            foreach(IGrouping<string,Osoba> grupa in listaGrupPoNazwiskach)
            {
                output += "\n";
                foreach (Osoba osoba in grupa)
                    output += osoba.ToString() + "\n";               
            }
            Console.WriteLine(output);

            var zapytanieSpłaszczające = listaGrupPoNazwiskach.SelectMany<IGrouping<string,Osoba>,Osoba>(grupa => grupa);

            //listaOsób.GroupJoin

            //Cast, OfType
            var kolekcjaDouble = listaOsób.Select(osoba => osoba.Wiek).Cast<double>();
            
            var listaObject = (listaOsób.Select(osoba => osoba.Wiek).Cast<object>()).ToList();
            listaObject.Add("Coś");
            listaObject.Add(-1);
            var listaInt = listaObject.OfType<int>();
            foreach (int element in listaInt) Console.WriteLine(element);
        }
    }
}
