﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

namespace AplikacjaWPF_LinqToSQL
{
    /// <summary>
    /// Interaction logic for MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window
    {
        public MainWindow()
        {
            InitializeComponent();
        }

        bool daneZmienione = false;
        private AplikacjaWPF_LinqToSQL.ListaOsobDataSet listaOsobDataSet;
        AplikacjaWPF_LinqToSQL.ListaOsobDataSetTableAdapters.OsobaTableAdapter listaOsobDataSetOsobaTableAdapter;

        private void Window_Loaded(object sender, RoutedEventArgs e)
        {
            listaOsobDataSet = ((AplikacjaWPF_LinqToSQL.ListaOsobDataSet)(this.FindResource("listaOsobDataSet")));
            // Load data into the table Osoba. You can modify this code as needed.
            listaOsobDataSetOsobaTableAdapter = new AplikacjaWPF_LinqToSQL.ListaOsobDataSetTableAdapters.OsobaTableAdapter();
            listaOsobDataSetOsobaTableAdapter.Fill(listaOsobDataSet.Osoba);
            System.Windows.Data.CollectionViewSource osobaViewSource = ((System.Windows.Data.CollectionViewSource)(this.FindResource("osobaViewSource")));
            osobaViewSource.View.MoveCurrentToFirst();
            // Load data into the table ListaRozmów. You can modify this code as needed.
            AplikacjaWPF_LinqToSQL.ListaOsobDataSetTableAdapters.ListaRozmówTableAdapter listaOsobDataSetListaRozmówTableAdapter = new AplikacjaWPF_LinqToSQL.ListaOsobDataSetTableAdapters.ListaRozmówTableAdapter();
            listaOsobDataSetListaRozmówTableAdapter.Fill(listaOsobDataSet.ListaRozmów);
            System.Windows.Data.CollectionViewSource osobaListaRozmówViewSource = ((System.Windows.Data.CollectionViewSource)(this.FindResource("osobaListaRozmówViewSource")));
            osobaListaRozmówViewSource.View.MoveCurrentToFirst();

            daneZmienione = false;
        }

        private void osobaDataGrid_CellEditEnding(object sender, DataGridCellEditEndingEventArgs e)
        {
            MessageBox.Show("Zakończona edycja komórki");
            daneZmienione = true;
        }

        private void Window_Closing(object sender, System.ComponentModel.CancelEventArgs e)
        {
            listaOsobDataSetOsobaTableAdapter.Update(listaOsobDataSet);
        }

        private void button_Click(object sender, RoutedEventArgs e)
        {
            var osobaViewSource = this.FindResource("osobaViewSource") as CollectionViewSource;
            ListaOsobDataSet.OsobaRow rekord = listaOsobDataSet.Osoba[osobaViewSource.View.CurrentPosition];
            MessageBox.Show(rekord.Imię + " " + rekord.Nazwisko + " (" + rekord.Wiek + ")");

            //LINQ to DataSet
            var zapytanie = from ListaOsobDataSet.OsobaRow osoba in listaOsobDataSet.Osoba
                            where osoba.Wiek >= 26
                            orderby osoba.Wiek descending
                            select osoba.Imię + " " + osoba.Nazwisko + " (" + osoba.Wiek + ")";

            string s = "";
            foreach (string element in zapytanie) s += element + "\n";
            MessageBox.Show(s);
        }
    }
}
