﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.Linq.Dynamic;

namespace LinqToObjects
{
    class Program
    {
        class Osoba
        {
            public int Id;
            public string Imię, Nazwisko;
            public int NumerTelefonu, Wiek;

            public override string ToString()
            {
                return Imię + " " + Nazwisko + " (" + Wiek + ")";
            }
        }

        private static List<Osoba> listaOsób = new List<Osoba>()
        {
            new Osoba() { Id = 0, Imię = "Jacek", Nazwisko = "Matulewski", NumerTelefonu = 123456789, Wiek = 44 },
            new Osoba() { Id = 1, Imię = "Bilbo", Nazwisko = "Baggins", NumerTelefonu = 27834628, Wiek = 133 },
            new Osoba() { Id = 2, Imię = "Frodo", Nazwisko = "Baggins", NumerTelefonu = 27834628, Wiek = 40 },
            new Osoba() { Id = 3, Imię = "Katarzyna", Nazwisko = "Matulewska", NumerTelefonu = 732673264, Wiek = 45 },
            new Osoba() { Id = 4, Imię = "Róża", Nazwisko = "Matulewska", Wiek = 13 }
        };

        static void Main(string[] args)
        {
            IEnumerable<string> zapytanie1 = from osoba in listaOsób
                                             where osoba.Wiek > 41
                                             orderby osoba.Wiek descending
                                             select osoba.ToString();

            IEnumerable<Osoba> zapytanie2 = from osoba in listaOsób
                                            where osoba.Wiek > 41
                                            orderby osoba.Wiek descending
                                            select osoba;

            int wiekMin = 41;
            var zapytanie1Dynamic = listaOsób.Where("Wiek > @0", wiekMin).OrderBy("Wiek DESCENDING").Select("new (Imię, Nazwisko, Wiek)");

            string s1 = "Lista osób:\n";
            //foreach (var element in zapytanie1Dynamic) s1 += element.Imię + " " + element.Nazwisko + "\n";
            Console.WriteLine(s1);

            return;

            var zapytanie = from osoba in listaOsób
                            where osoba.Wiek > 41
                            orderby osoba.Wiek descending
                            select new { osoba.Imię, osoba.Nazwisko, osoba.Wiek };

            /*
            string s = "Lista osób:\n";
            foreach (var element in zapytanie) s += element.Imię + " " + element.Nazwisko + "\n";
            Console.WriteLine(s);

            s = "Lista osób:\n";
            foreach (var element in listaOsób) s += element.ToString() + "\n";
            Console.WriteLine(s);

            //zapytanie2.ElementAt(0).Imię = "Barnaba";

            s = "Lista osób:\n";
            foreach (var element in listaOsób) s += element.ToString() + "\n";
            Console.WriteLine(s);
            */

            //----------------------------

            /*
            Func<Osoba, int> selector = (Osoba osoba) => { return osoba.Wiek; };
            int maksymalnyWiek = listaOsób.Max(selector);
            Console.WriteLine(maksymalnyWiek.ToString());

            Osoba maxOsoba = listaOsób.First(osoba => osoba.Wiek == maksymalnyWiek);
            Console.WriteLine(maxOsoba.ToString());

            decimal średniaWieku = listaOsób.Average(osoba => (decimal)osoba.Wiek);
            Console.WriteLine(średniaWieku.ToString());

            bool czyWLiścieJestOsobaPełnoletnia = listaOsób.Any(osoba => osoba.Wiek >= 18);
            bool czyWLiścieWszystkieOsobySąPełnoletnie = listaOsób.All(osoba => osoba.Wiek >= 18);
            */

            var grupyOsóbOTymSamymNazwisku = from osoba in listaOsób
                                             group osoba by osoba.Nazwisko.Substring(0,5) into grupa
                                             select grupa;

            foreach(var grupa in grupyOsóbOTymSamymNazwisku)
            {
                Console.WriteLine("Grupa osób o nazwisku " + grupa.Key + "...");
                foreach (Osoba osoba in grupa)
                    Console.WriteLine(osoba.ToString());
                Console.WriteLine();
            }

            var listaOsóbDorosłych = from osoba in listaOsób
                                     where osoba.Wiek > 40
                                     select osoba;
            var listaKobiet = from osoba in listaOsób
                              where osoba.Imię.EndsWith("a")
                              select osoba;

            //var kolekcjaOsóbDorosłychLubKobiet = listaOsóbDorosłych.Concat(listaKobiet).Distinct();
            var kolekcjaOsóbDorosłychLubKobiet = listaOsóbDorosłych.Union(listaKobiet);

            var listaKobietDorosłych = listaOsóbDorosłych.Intersect(listaKobiet);


            var listaPersonaliów = from osoba in listaOsób
                                   select new { osoba.Id, osoba.Imię, osoba.Nazwisko, osoba.Wiek };
            var listaTelefonów = from osoba in listaOsób
                                 select new { osoba.Id, osoba.NumerTelefonu };

            var listaPersonaliówITelefonów = from personalia in listaPersonaliów
                                             join telefon in listaTelefonów
                                             on personalia.Id equals telefon.Id
                                             //select new Osoba() { Id = personalia.Id, Imię = personalia.Imię, Nazwisko = personalia.Nazwisko, Wiek = personalia.Wiek, NumerTelefonu = telefon.NumerTelefonu };
                                             select personalia.Imię + " " + personalia.Nazwisko + ", tel. " + telefon.NumerTelefonu;

            string s = "Lista osób:\n";
            foreach (var element in listaPersonaliówITelefonów) s += element.ToString() + "\n";
            Console.WriteLine(s);
        }
    }
}
