﻿using System;
using System.Collections.Generic;
using System.Data.Linq;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

namespace AplikacjaWPF_LinqToSQL
{
    /// <summary>
    /// Interaction logic for MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window
    {
        public MainWindow()
        {
            InitializeComponent();
        }

        const string connectionString = @"Data Source=(LocalDB)\MSSQLLocalDB;AttachDbFilename=|DataDirectory|\ListaOsob.mdf;Integrated Security=True";
        static DataContext bazaDanych = new DataContext(connectionString);
        static Table<Osoba> listaOsób = bazaDanych.GetTable<Osoba>();

        private void button_Click(object sender, RoutedEventArgs e)
        {
            MessageBox.Show(listaOsób.Count().ToString());

            var listaOsóbPełnoletnich = from Osoba osoba in listaOsób
                                        where osoba.Wiek >= 18
                                        orderby osoba.Nazwisko, osoba.Imię
                                        select new { osoba.Imię, osoba.Nazwisko, osoba.Wiek };
                                        //select osoba;

            string s = "Lista osób:\n";
            foreach (var osoba in listaOsóbPełnoletnich) s += osoba.Imię + " " + osoba.Nazwisko + " (" + osoba.Wiek + ")\n";
            MessageBox.Show(s);

            dataGrid.ItemsSource = listaOsóbPełnoletnich;
        }

        private void button1_Click(object sender, RoutedEventArgs e)
        {
            var listaOsóbDoZmianyWieku = from osoba in listaOsób
                                         where osoba.Wiek < 40
                                         select osoba;

            string s = "Przed zmianą:\n";
            foreach (var osoba in listaOsóbDoZmianyWieku) s += osoba.Imię + " " + osoba.Nazwisko + " (" + osoba.Wiek + ")\n";
            MessageBox.Show(s);

            foreach (Osoba osoba in listaOsóbDoZmianyWieku) osoba.Wiek++;

            s = "Po zmianie:\n";
            foreach (var osoba in listaOsóbDoZmianyWieku) s += osoba.Imię + " " + osoba.Nazwisko + " (" + osoba.Wiek + ")\n";
            MessageBox.Show(s);

            bazaDanych.SubmitChanges();
        }

        private void button2_Click(object sender, RoutedEventArgs e)
        {
            int noweId = listaOsób.Max(osoba => osoba.Id);

            listaOsób.InsertOnSubmit(
                new Osoba()
                {
                    Id = noweId + 1,
                    Imię = "Jan",
                    Nazwisko = "Musiał",
                    NumerTelefonu = 123,
                    Wiek = 21
                });

            bazaDanych.SubmitChanges();
        }
    }
}
