﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace MetodyRozszerzające
{
    static class Rozszerzenia
    {
        public static string UsuńApostrof(this string s)
        {
            return s.Replace('\'', '#');
        }

        public static string UsuńApostrof(this string s, char nowyZnak = '#')
        {
            return s.Replace('\'', nowyZnak);
        }

        public static string UsuńApostrof(this string s, Func<char,char> zmieniacz)
        {
            return s.Replace('\'', zmieniacz('\'')).Replace('\"', zmieniacz('\"'));
        }

        public static double Odchylenie(this IEnumerable<double> kol)
        {
            double wynik = 0.0, srednia = 0.0;
            foreach (double el in kol)
            {
                srednia += el;
            }
            srednia /= kol.Count();

            foreach (double el in kol)
            {
                wynik += Math.Pow(el - srednia, 2);
            }
            wynik /= kol.Count() - 1.0;
            return Math.Sqrt(wynik);
        }

        /*
        public static double Odchylenie(this IEnumerable<int> kol)
        {
            List<double> kol2 = new List<double>();
            foreach (int item in kol)
            {
                kol2.Add((double)item);
            }
            return Odchylenie(kol2);
        }
        */

        public static double Odchylenie<T>(this IEnumerable<T> kol, Func<T,double> selector)
        {
            List<double> kol2 = new List<double>();
            foreach (T item in kol) kol2.Add(selector(item));
            return Odchylenie(kol2);
        }
    }

    class Program
    {

       
        static void Main(string[] args)
        {
            string tekst = "Łańcucha '' z Apo'strofami";
            Console.WriteLine(Rozszerzenia.UsuńApostrof(tekst));
            Console.WriteLine(tekst.UsuńApostrof());
            Console.WriteLine(tekst.UsuńApostrof('?'));
            Console.WriteLine(tekst.UsuńApostrof((char znak) => { return '%'; }));
            Console.WriteLine(tekst.UsuńApostrof(znak => '%' ));

            List<double> ld = new List<double>() { 1, 2, 3, 4, 5 };
            Console.WriteLine(ld.Odchylenie());

            List<int> li = new List<int>() { 1, 2, 3, 4, 5 };
            //Console.WriteLine(li.Odchylenie());
            Console.WriteLine(li.Odchylenie<int>((int item) => { return (double)item; }));
            Console.WriteLine(li.Odchylenie(item => item));
        }
    }
}
