﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace LinqToObjects
{
    class Program
    {
        class Osoba
        {
            public int Id;
            public string Imię, Nazwisko;
            public int NumerTelefonu, Wiek;

            public override string ToString()
            {
                return Imię + " " + Nazwisko + " (" + Wiek + ")";
            }
        }

        private static List<Osoba> listaOsób = new List<Osoba>()
        {
            new Osoba() { Id = 0, Imię = "Jacek", Nazwisko = "Matulewski", NumerTelefonu = 123456789, Wiek = 44 },
            new Osoba() { Id = 1, Imię = "Bilbo", Nazwisko = "Baggins", NumerTelefonu = 27834628, Wiek = 133 },
            new Osoba() { Id = 2, Imię = "Frodo", Nazwisko = "Baggins", NumerTelefonu = 27834628, Wiek = 40 },
            new Osoba() { Id = 3, Imię = "Katarzyna", Nazwisko = "Matulewska", NumerTelefonu = 732673264, Wiek = 45 },
            new Osoba() { Id = 4, Imię = "Róża", Nazwisko = "Matulewska", Wiek = 13 }
        };

        static void Main(string[] args)
        {
            IEnumerable<string> zapytanie1 = from osoba in listaOsób
                                             where osoba.Wiek > 41
                                             orderby osoba.Wiek descending
                                             select osoba.ToString();

            IEnumerable<string> zapytanie2 = listaOsób
                .Where(osoba => osoba.Wiek > 41)
                .OrderByDescending(osoba => osoba.Wiek)
                .Select(osoba => osoba.ToString());

            string s = "Lista osób:\n";
            foreach (var element in zapytanie1) s += element.ToString() + "\n";
            Console.WriteLine(s);
            Console.WriteLine();

            s = "Lista osób:\n";
            foreach (var element in zapytanie2) s += element.ToString() + "\n";
            Console.WriteLine(s);

            IEnumerable<Osoba> listaOsóbPełnoletnich = from osoba in listaOsób
                                                       where osoba.Wiek >= 18
                                                       select osoba;
            IEnumerable<Osoba> lop_Lepiej = listaOsób.Where(osoba => osoba.Wiek >= 18);
        }
    }
}
