﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace MetodyRozszerzające
{
    static class Rozszerzenia
    {
        public static string UsuńApostrof(this string s)
        {
            return s.Replace('\'', '#');
        }

        public static string UsuńApostrof(this string s, char nowyZnak = '#')
        {
            return s.Replace('\'', nowyZnak);
        }

        public static string UsuńApostrof(this string s, Func<char,char> zmieniacz)
        {
            return s.Replace('\'', zmieniacz('\'')).Replace('\"', zmieniacz('\"'));
        }
    }

    class Program
    {
        static void Main(string[] args)
        {
            string tekst = "Łańcucha '' z Apo'strofami";
            Console.WriteLine(Rozszerzenia.UsuńApostrof(tekst));
            Console.WriteLine(tekst.UsuńApostrof());
            Console.WriteLine(tekst.UsuńApostrof('?'));
            Console.WriteLine(tekst.UsuńApostrof((char znak) => { return '%'; }));
            Console.WriteLine(tekst.UsuńApostrof(znak => '%' ));

            List<double> ld = new List<double>() { 1, 2, 3, 4, 5 };
            //ld.OdchylenieStandardowe();

            List<int> li = new List<int>() { 1, 2, 3, 4, 5 };
            //li.OdchylenieStandardowe(liczba => (double)liczba);
        }
    }
}
