﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

namespace ChoinkaWPF
{
    /// <summary>
    /// Interaction logic for MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window
    {
        System.Media.SoundPlayer player = new System.Media.SoundPlayer();

        private bool isPlaying = true;

        public MainWindow()
        {
            InitializeComponent();
        }

        private void Window_Loaded(object sender, RoutedEventArgs e)
        {
            player.SoundLocation = "Choinka.wav";
            player.Play();
        }

        private void Window_MouseDown_1(object sender, MouseButtonEventArgs e)
        {
            if (e.ChangedButton == MouseButton.Left)
                this.DragMove();
        }

        private void MenuItem_Click(object sender, RoutedEventArgs e)
        {
            MessageBox.Show("Kurs .NET; Wersja WPF\n Mateusz Kuchta");
        }

        private void DniDoWigiliiClick(object sender, RoutedEventArgs e)
        {
            DateTime bieżącaData = DateTime.Today;
            DateTime dataWigilii = new DateTime(bieżącaData.Year, 12, 24);
            if (bieżącaData > dataWigilii) MessageBox.Show("Już po Wigilii");
            else if (bieżącaData == dataWigilii) MessageBox.Show("Dziś jest Wigilia!");
            else
            {
                int ileDniDoWigilii = (dataWigilii - bieżącaData).Days;
                if (ileDniDoWigilii == 1) MessageBox.Show("Jutro Wigilia!");
                else MessageBox.Show("Do Wigilii zostało " + ileDniDoWigilii + " dni");
            }
        }
        private void WylaczMuzyke(object sender, RoutedEventArgs e)
        {
            if (isPlaying)
            {
                player.Stop();
                isPlaying = false;
            }
            else
            {
                player.Play();
                isPlaying = true;
            }
        }

        private void ZamknijClick(object sender, RoutedEventArgs e)
        {
            Close();
        }

        
    }
}
