﻿using System;
using System.IO;
using System.Media;
using System.Windows;
using System.Windows.Input;
using System.Windows.Forms;
using System.Drawing;

namespace ChoinkaWPF
{
    /// <summary>
    /// Interaction logic for MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window
    {
        NotifyIcon nIcon = new NotifyIcon();
        
        public MainWindow()
        {
            InitializeComponent();
            
            nIcon.Icon = new Icon("icon.ico");
            nIcon.Visible = true;
            nIcon.Click += nIcon_Click;
            nIcon.ShowBalloonTip(5000, "Wesołego po Świętach i Szczęśliwego Nowego Roku!", "od Choinki :D", ToolTipIcon.None);
            nIcon.DoubleClick += nIcon_MouseDoubleClick;
            
            string ścieżka = System.IO.Path.Combine(System.IO.Path.GetDirectoryName(System.Reflection.Assembly.GetExecutingAssembly().Location), "Choinka.wav");
            if (File.Exists(ścieżka))
            {                
                SoundPlayer sp = new SoundPlayer(ścieżka);
                sp.Load();
                sp.PlayLooping();
            }
            else System.Windows.MessageBox.Show("Brak pliku z muzyką " + ścieżka, "Błąd", MessageBoxButton.OK, MessageBoxImage.Warning);
        }       

        private void ileDniDoWigiliiMenuItem_Click(object sender, EventArgs e)
        {
            DateTime bieżącaData = DateTime.Today;
            DateTime dataWigilii = new DateTime(bieżącaData.Year, 12, 24);
            if (bieżącaData > dataWigilii) System.Windows.MessageBox.Show("Już po Wigilii");
            else if (bieżącaData == dataWigilii) System.Windows.MessageBox.Show("Dziś jest Wigilia!");
            else
            {
                int ileDniDoWigilii = (dataWigilii - bieżącaData).Days;
                if (ileDniDoWigilii == 1) System.Windows.MessageBox.Show("Jutro Wigilia!");
                else System.Windows.MessageBox.Show("Do Wigilii zostało " + ileDniDoWigilii + " dni");
            }
        }

        private void ileCzasuDoNowegoRokuMenuItem_Click(object sender, EventArgs e)
        {
            DateTime bieżącaData = DateTime.Now;
            DateTime NowyRok = new DateTime(bieżącaData.Year+1, 1, 1, 0, 0, 0);
            int minuty, godziny, sekundy;
            if (bieżącaData > NowyRok)
            {
                System.Windows.MessageBox.Show("Szczęśliwego Nowego Roku!");
            }
            else
            {
                minuty = (NowyRok - bieżącaData).Minutes;
                godziny = (NowyRok - bieżącaData).Hours;
                sekundy = (NowyRok - bieżącaData).Seconds;
                System.Windows.MessageBox.Show("Zostało jeszcze: " + godziny + " h : " + minuty + " min : " + sekundy + " s");
            }
        }

        private void zamknijMenuItem_Click(object sender, RoutedEventArgs e)
        {
            Close();
        }

        private void infoMenuItem_Click(object sender, RoutedEventArgs e)
        {
            System.Windows.MessageBox.Show("Choinka - Kurs .NET 2016/2017\n\nŁukasz Pijawski");
        }
      
        private void ukryjMenuItem_Click(object sender, RoutedEventArgs e)
        {
            if (IsVisible)
            {
                Visibility = Visibility.Collapsed;
            }
            else
            {
                Visibility = Visibility.Visible;
            }
        }

        void nIcon_Click(object sender, EventArgs e)
        {            
            Visibility = Visibility.Visible;
            WindowState = WindowState.Normal;            
        }
        
        private void nIcon_MouseDoubleClick(object sender, EventArgs e)
        {
            nIcon.ShowBalloonTip(5000, "Wesołego po Świętach i Szczęśliwego Nowego Roku!", "od Choinki :D", ToolTipIcon.None);
        }       

        private void Grid_MouseDown(object sender, MouseButtonEventArgs e)
        {
            if (e.ChangedButton == MouseButton.Left)
            {
                DragMove();
            }
        }
    }
}
