﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using JacekMatulewski.Collections;

namespace CompositeDemo
{
    class Program
    {
        interface IPracownik
        {
            string Personalia { get; }
            string Stanowisko { get; }
        }

        class Pracownik : IPracownik
        {
            public string Personalia { get; set; }
            public string Stanowisko { get; set; }

            public override string ToString()
            {
                return Personalia + " (" + Stanowisko + ")";
            }
        }

        static void Main(string[] args)
        {
            Pracownik rektor = new Pracownik() { Stanowisko = "rektor", Personalia = "Andrzej Tretyn" };
            Pracownik prorektor = new Pracownik() { Stanowisko = "prorektor", Personalia = "Beata Przyborowska" };
            Pracownik dziekanWFAiIS = new Pracownik() { Stanowisko = "dziekan", Personalia = "Włodzimierz Jaskólski" };
            Pracownik kierownikZMK = new Pracownik() { Stanowisko = "kierownik zakładu", Personalia = "Michał Zieliński" };
            Pracownik pracownik1 = new Pracownik() { Stanowisko = "adiunnkt", Personalia = "Jacek Matulewski" };
            Pracownik pracownik2 = new Pracownik() { Stanowisko = "asystent", Personalia = "Karolina Słowik" };
            Pracownik pracownik3 = new Pracownik() { Stanowisko = "profesor", Personalia = "Jarosław Zaremba" };
            CompositeNode<Pracownik> rektorNode = new CompositeNode<Pracownik>(rektor);
            rektorNode.AddSubNode(prorektor);
            CompositeNode<Pracownik> dziekanNode = new CompositeNode<Pracownik>(dziekanWFAiIS);
            rektorNode.AddSubNode(dziekanNode);
            CompositeNode<Pracownik> kierownikNode = new CompositeNode<Pracownik>(kierownikZMK);
            dziekanNode.AddSubNode(kierownikNode);
            kierownikNode.AddSubNode(pracownik1);
            kierownikNode.AddSubNode(pracownik2);
            kierownikNode.AddSubNode(pracownik3);

            //tworzenie cyklu
            kierownikNode.AddSubNode(dziekanNode);

            Console.WriteLine(rektorNode.Count());

            Composite<Pracownik> kompozyt = new Composite<Pracownik>(rektorNode);
            Console.WriteLine(kompozyt.Count());

            List<CompositeNode<Pracownik>> pracownicy = kompozyt.ToList();
            foreach (CompositeNode<Pracownik> pracownik in pracownicy) Console.WriteLine(pracownik.Value.ToString());
        }
    }
}
