﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace JacekMatulewski.Collections
{
    public interface ICompositeVisitor<N>
    {
        bool CanVisit(N node, N parentNode, uint depth);
        void Visit(N node, N parentNode, uint depth);
        bool IsCycleDetected { get; set; }
    }

    public class CompositeNodeVisitor<T> : ICompositeVisitor<CompositeNode<T>>
    {
        private Action<CompositeNode<T>, CompositeNode<T>, uint> visit;
        private Func<CompositeNode<T>, CompositeNode<T>, uint, bool> canVisit;

        public bool IsCycleDetected { get; set; }

        public CompositeNodeVisitor(Action<CompositeNode<T>, CompositeNode<T>, uint> visit, Func<CompositeNode<T>, CompositeNode<T>, uint, bool> canVisit = null)
        {
            if (visit == null) throw new ArgumentNullException(nameof(visit));
            this.visit = visit;
            this.canVisit = canVisit;
        }

        public bool CanVisit(CompositeNode<T> node, CompositeNode<T> parentNode, uint depth)
        {
            if (canVisit == null) return true;
            else return canVisit(node, parentNode, depth);
        }

        public void Visit(CompositeNode<T> node, CompositeNode<T> parentNode, uint depth)
        {
            visit(node, parentNode, depth);
        }
    }

    /*
    public class CompositeValueVisitor<T> : ICompositeVisitor<CompositeNode<T>>
    {
        private Action<T, T, uint> visit;
        private Func<T, T, uint, bool> canVisit;

        public CompositeNodeVisitor(Action<T, T, uint> visit, Func<T, T, uint, bool> canVisit)
        {
            if (visit == null) throw new ArgumentNullException(nameof(visit));
            this.visit = visit;
            this.canVisit = canVisit;
        }

        public bool CanVisit(CompositeNode<T> node, CompositeNode<T> parentNode, uint depth)
        {
            if (canVisit == null) return true;
            else return canVisit(node, parentNode, depth);
        }

        public void Visit(CompositeNode<T> node, CompositeNode<T> parentNode, uint depth)
        {
            visit(node, parentNode, depth);
        }
    }
    */
}
