﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace JacekMatulewski.Collections
{
    public class CompositeNode<T>
    {
        public T Value { get; set; }
        public CompositeNode<T> ParentNode { get; private set; }
        public List<CompositeNode<T>> SubNodes { get; private set; }

        public CompositeNode(T value)
        {
            ParentNode = null;
            SubNodes = new List<CompositeNode<T>>();
            this.Value = value;
        }

        public bool HasSubNodes
        {
            get
            {
                return SubNodes.Count != 0;
            }
        }

        public void AddSubNode(CompositeNode<T> node)
        {
            node.ParentNode = this;
            SubNodes.Add(node);
        }

        public void AddSubNode(T value)
        {
            AddSubNode(new CompositeNode<T>(value));
        }

        public int Count()
        {
            return SubNodes.Count;
        }

        public void AcceptVisit(ICompositeVisitor<CompositeNode<T>> visitor, uint depth = 0)
        {
            if(visitor.CanVisit(this, ParentNode, depth))
            {
                if (!visited)
                {
                    visitor.Visit(this, ParentNode, depth);
                    visited = true;
                    //reset = false;
                    foreach (CompositeNode<T> node in SubNodes) node.AcceptVisit(visitor, depth + 1);
                }
                else
                {
                    visitor.IsCycleDetected = true;
                }
            }
            if (depth == 0) Reset();
        }

        protected bool visited = false;//, reset = true;

        protected void Reset()
        {
            visited = false;
            //reset = true;
            foreach (CompositeNode<T> node in SubNodes)
                if (node.visited) node.Reset();
        }
    }

    public class Composite<T> : IEnumerable<T>, IEnumerable<CompositeNode<T>>
    {
        public CompositeNode<T> RootNode { get; private set; }

        public void SetRootNode(CompositeNode<T> rootNode)
        {
            this.RootNode = rootNode;
        }

        public void SetRootNodeValue(T value)
        {
            if (RootNode == null) RootNode = new CompositeNode<T>(value);
            RootNode.Value = value;
        }

        public Composite(CompositeNode<T> rootNode)
        {
            SetRootNode(rootNode);
        }

        public Composite(T rootNodeValue)
        {
            SetRootNodeValue(rootNodeValue);
        }

        public int Count()
        {
            int counter = 0;
            CompositeNodeVisitor<T> countVisitor = new CompositeNodeVisitor<T>(
                (CompositeNode<T> node, CompositeNode<T> parentNode, uint depth) =>
                {
                    counter++;
                });
            RootNode.AcceptVisit(countVisitor);
            return counter;
        }

        public List<CompositeNode<T>> ToList()
        {
            List<CompositeNode<T>> nodeList = new List<CompositeNode<T>>();
            CompositeNodeVisitor<T> listVisitor = new CompositeNodeVisitor<T>(
                (CompositeNode<T> node, CompositeNode<T> parentNode, uint depth) =>
                {
                    nodeList.Add(node);
                });
            RootNode.AcceptVisit(listVisitor);
            return nodeList;
        }

        public List<T> ToValueList()
        {
            //użyć CompositeValueVisitor
            throw new NotImplementedException();
        }

        public IEnumerator<T> GetEnumerator()
        {
            throw new NotImplementedException();
        }

        IEnumerator<CompositeNode<T>> IEnumerable<CompositeNode<T>>.GetEnumerator()
        {
            throw new NotImplementedException();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            throw new NotImplementedException();
        }
    }
}
