﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using System.IO;

namespace Choinka_WinForms
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();

            Width = pictureBox1.Image.Width;
            Height = pictureBox1.Image.Height;

            string ścieżka = Path.Combine(Path.GetDirectoryName(Application.ExecutablePath), "Choinka.wav");
            if (File.Exists(ścieżka))
            {
                System.Media.SoundPlayer sp = new System.Media.SoundPlayer(ścieżka);
                sp.PlayLooping();
            }
            else MessageBox.Show("Brak pliku z muzyką " + ścieżka, Text, MessageBoxButtons.OK, MessageBoxIcon.Warning);

            //WPF: System.Windows.Media.Player
        }

        #region Przenoszenie okna
        Point położeniePoczątkowe = Point.Empty;

        private void pictureBox1_MouseMove(object sender, MouseEventArgs e)
        {
            if (e.Button == MouseButtons.Left)
            {
                if (położeniePoczątkowe.IsEmpty) położeniePoczątkowe = e.Location;
                else
                {
                    Left += e.Location.X - położeniePoczątkowe.X;
                    Top += e.Location.Y - położeniePoczątkowe.Y;
                }
            }
            else położeniePoczątkowe = Point.Empty;
        }
        #endregion

        private void zamknijToolStripMenuItem_Click(object sender, EventArgs e)
        {
            Close();
        }

        private void oToolStripMenuItem_Click(object sender, EventArgs e)
        {
            MessageBox.Show("Choinka - Kurs .NET 2016/2017");
        }

        private void ileDniDoWigiliiToolStripMenuItem_Click(object sender, EventArgs e)
        {
            DateTime bieżącaData = DateTime.Today;
            DateTime dataWigilii = new DateTime(bieżącaData.Year, 12, 24);
            if (bieżącaData > dataWigilii) MessageBox.Show("Już po Wigilii");
            else if (bieżącaData == dataWigilii) MessageBox.Show("Dziś jest Wigilia!");
            else
            {
                int ileDniDoWigilii = (dataWigilii - bieżącaData).Days;
                if (ileDniDoWigilii == 1) MessageBox.Show("Jutro Wigilia!");
                else MessageBox.Show("Do Wigilii zostało " + ileDniDoWigilii + " dni");
            }
        }

        private void toolStripMenuItem2_Click(object sender, EventArgs e)
        {
            this.Visible = !this.Visible;
        }

        private void notifyIcon1_MouseDoubleClick(object sender, MouseEventArgs e)
        {
            notifyIcon1.ShowBalloonTip(3000);
        }
    }
}
