﻿using System;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using Sumowanie;

namespace TestyJednostkowe
{
    [TestClass]
    public class UnitTest1
    {
        [TestMethod]
        public void TestKonstruktora()
        {
            //arrange
            decimal suma = 100;
            decimal limit = 1000;

            //act
            Sumowanie.Sumowanie model = new Sumowanie.Sumowanie(suma, limit);

            //assert
            PrivateObject po = new PrivateObject(model);
            decimal po_suma = (decimal)po.GetField("suma");
            Assert.AreEqual(suma, po_suma);

            decimal po_limit = (decimal)po.GetField("limit");
            Assert.AreEqual(limit, po_limit);
        }

        [TestMethod]
        public void TestWłasności()
        {
            //arrange
            decimal suma = 100;
            Sumowanie.Sumowanie model = new Sumowanie.Sumowanie();
            PrivateObject po = new PrivateObject(model);
            po.SetField("suma", suma);

            //act
            decimal model_suma = model.Suma;

            //assert
            Assert.AreEqual(suma, model_suma);
        }

        [TestMethod]
        public void TestKonstruktoraIWłasności()
        {
            //arrange - act
            Sumowanie.Sumowanie model = new Sumowanie.Sumowanie(100, 1200);

            //assert
            Assert.AreEqual(100, model.Suma);
        }

        [TestMethod]
        public void TestDodajKwotę()
        {
            //arrange
            decimal suma = 100;
            decimal limit = 1200;
            decimal kwota = 250.2M;
            Sumowanie.Sumowanie model = new Sumowanie.Sumowanie(suma, limit);

            //act
            model.DodajKwotę(kwota);

            //assert
            Assert.AreEqual(suma + kwota, model.Suma);
        }

        [TestMethod]
        [ExpectedException(typeof(ArgumentOutOfRangeException))]
        public void TestDodajKwotęWyjątek()
        {
            //arrange
            decimal suma = 100;
            decimal limit = 1200;
            decimal kwota = 2000;
            Sumowanie.Sumowanie model = new Sumowanie.Sumowanie(suma, limit);

            //act
            model.DodajKwotę(kwota);

            //assert
            Assert.AreEqual(suma + kwota, model.Suma);            
        }

        [TestMethod]
        public void TestTestujKwotę()
        {            
            decimal suma = 100;
            decimal limit = 1200;
            decimal kwota1 = 250.2M;
            decimal kwota2 = 2000;

            //arrange
            Sumowanie.Sumowanie model1 = new Sumowanie.Sumowanie(suma, limit);
            //act
            bool wynik1 = model1.TestujKwote(kwota1);
            //assert
            Assert.IsTrue(wynik1);

            //arrange
            Sumowanie.Sumowanie model2 = new Sumowanie.Sumowanie(suma, limit);
            //act
            bool wynik2 = model2.TestujKwote(kwota2);
            //assert
            Assert.IsFalse(wynik2);
        }
    }
}
