﻿using System;

//POCO

namespace Sumowanie
{
    public class Sumowanie //model
    {
        private decimal suma;
        private decimal limit;

        public decimal Suma
        {
            get
            {
                return suma;
            }
        }

        public bool TestujKwote(decimal kwota)
        {
            return !((kwota + suma) > limit);
        }

        public void DodajKwotę(decimal kwota)
        {
            if (!TestujKwote(kwota)) throw new Exception("Forsa się skończyła!");
            else suma += kwota;
        }

        public Sumowanie(decimal sumaPoczątkowa = 0, decimal limit = 1000)
        {
            suma = sumaPoczątkowa;
            this.limit = limit;
        }


    }
}
